/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.search;

import java.io.IOException;
import org.easysearch.action.ActionResponse;
import org.easysearch.common.ParseField;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.ObjectParser;
import org.easysearch.common.xcontent.StatusToXContentObject;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.rest.RestStatus;

public class ClearScrollResponse
extends ActionResponse
implements StatusToXContentObject {
    private static final ParseField SUCCEEDED = new ParseField("succeeded", new String[0]);
    private static final ParseField NUMFREED = new ParseField("num_freed", new String[0]);
    private static final ConstructingObjectParser<ClearScrollResponse, Void> PARSER = new ConstructingObjectParser("clear_scroll", true, a -> new ClearScrollResponse((Boolean)a[0], (Integer)a[1]));
    private final boolean succeeded;
    private final int numFreed;

    public ClearScrollResponse(boolean succeeded, int numFreed) {
        this.succeeded = succeeded;
        this.numFreed = numFreed;
    }

    public ClearScrollResponse(StreamInput in) throws IOException {
        super(in);
        this.succeeded = in.readBoolean();
        this.numFreed = in.readVInt();
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public int getNumFreed() {
        return this.numFreed;
    }

    @Override
    public RestStatus status() {
        return this.numFreed == 0 ? RestStatus.NOT_FOUND : RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SUCCEEDED.getPreferredName(), this.succeeded);
        builder.field(NUMFREED.getPreferredName(), this.numFreed);
        builder.endObject();
        return builder;
    }

    public static ClearScrollResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.apply(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.succeeded);
        out.writeVInt(this.numFreed);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.booleanValue(), SUCCEEDED, ObjectParser.ValueType.BOOLEAN);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.intValue(), NUMFREED, ObjectParser.ValueType.INT);
    }
}

