/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.action.termvectors;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.easysearch.action.ActionResponse;
import org.easysearch.action.termvectors.MultiTermVectorsResponse;
import org.easysearch.action.termvectors.TermVectorsResponse;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;

public class MultiTermVectorsShardResponse
extends ActionResponse {
    final IntArrayList locations;
    final List<TermVectorsResponse> responses;
    final List<MultiTermVectorsResponse.Failure> failures;

    MultiTermVectorsShardResponse() {
        this.locations = new IntArrayList();
        this.responses = new ArrayList<TermVectorsResponse>();
        this.failures = new ArrayList<MultiTermVectorsResponse.Failure>();
    }

    MultiTermVectorsShardResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.responses = new ArrayList<TermVectorsResponse>(size);
        this.failures = new ArrayList<MultiTermVectorsResponse.Failure>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                this.responses.add(new TermVectorsResponse(in));
            } else {
                this.responses.add(null);
            }
            if (in.readBoolean()) {
                this.failures.add(new MultiTermVectorsResponse.Failure(in));
                continue;
            }
            this.failures.add(null);
        }
    }

    public void add(int location, TermVectorsResponse response) {
        this.locations.add(location);
        this.responses.add(response);
        this.failures.add(null);
    }

    public void add(int location, MultiTermVectorsResponse.Failure failure) {
        this.locations.add(location);
        this.responses.add(null);
        this.failures.add(failure);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.responses.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.responses.get(i).writeTo(out);
            }
            if (this.failures.get(i) == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            this.failures.get(i).writeTo(out);
        }
    }
}

