/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client;

import java.util.Objects;
import org.easysearch.client.Validatable;
import org.easysearch.tasks.TaskId;

public class RethrottleRequest
implements Validatable {
    static final String REQUEST_PER_SECOND_PARAMETER = "requests_per_second";
    private final TaskId taskId;
    private final float requestsPerSecond;

    public RethrottleRequest(TaskId taskId) {
        this.taskId = taskId;
        this.requestsPerSecond = Float.POSITIVE_INFINITY;
    }

    public RethrottleRequest(TaskId taskId, float requestsPerSecond) {
        Objects.requireNonNull(taskId, "taskId cannot be null");
        if (requestsPerSecond <= 0.0f) {
            throw new IllegalArgumentException("requestsPerSecond needs to be positive value but was [" + requestsPerSecond + "]");
        }
        this.taskId = taskId;
        this.requestsPerSecond = requestsPerSecond;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public String toString() {
        return "RethrottleRequest: taskID = " + this.taskId + "; reqestsPerSecond = " + this.requestsPerSecond;
    }
}

