/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.indexlifecycle;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.easysearch.client.indexlifecycle.LifecycleAction;
import org.easysearch.common.ParseField;
import org.easysearch.common.Strings;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;

public class AllocateAction
implements LifecycleAction,
ToXContentObject {
    public static final String NAME = "allocate";
    static final ParseField NUMBER_OF_REPLICAS_FIELD = new ParseField("number_of_replicas", new String[0]);
    static final ParseField INCLUDE_FIELD = new ParseField("include", new String[0]);
    static final ParseField EXCLUDE_FIELD = new ParseField("exclude", new String[0]);
    static final ParseField REQUIRE_FIELD = new ParseField("require", new String[0]);
    private static final ConstructingObjectParser<AllocateAction, Void> PARSER = new ConstructingObjectParser("allocate", true, a -> new AllocateAction((Integer)a[0], (Map)a[1], (Map)a[2], (Map)a[3]));
    private final Integer numberOfReplicas;
    private final Map<String, String> include;
    private final Map<String, String> exclude;
    private final Map<String, String> require;

    public static AllocateAction parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public AllocateAction(Integer numberOfReplicas, Map<String, String> include, Map<String, String> exclude, Map<String, String> require) {
        this.include = include == null ? Collections.emptyMap() : include;
        this.exclude = exclude == null ? Collections.emptyMap() : exclude;
        this.require = require == null ? Collections.emptyMap() : require;
        if (this.include.isEmpty() && this.exclude.isEmpty() && this.require.isEmpty() && numberOfReplicas == null) {
            throw new IllegalArgumentException("At least one of " + INCLUDE_FIELD.getPreferredName() + ", " + EXCLUDE_FIELD.getPreferredName() + " or " + REQUIRE_FIELD.getPreferredName() + "must contain attributes for action allocate");
        }
        if (numberOfReplicas != null && numberOfReplicas < 0) {
            throw new IllegalArgumentException("[" + NUMBER_OF_REPLICAS_FIELD.getPreferredName() + "] must be >= 0");
        }
        this.numberOfReplicas = numberOfReplicas;
    }

    public Integer getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public Map<String, String> getInclude() {
        return this.include;
    }

    public Map<String, String> getExclude() {
        return this.exclude;
    }

    public Map<String, String> getRequire() {
        return this.require;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numberOfReplicas != null) {
            builder.field(NUMBER_OF_REPLICAS_FIELD.getPreferredName(), this.numberOfReplicas);
        }
        builder.field(INCLUDE_FIELD.getPreferredName(), this.include);
        builder.field(EXCLUDE_FIELD.getPreferredName(), this.exclude);
        builder.field(REQUIRE_FIELD.getPreferredName(), this.require);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.numberOfReplicas, this.include, this.exclude, this.require);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AllocateAction other = (AllocateAction)obj;
        return Objects.equals(this.numberOfReplicas, other.numberOfReplicas) && Objects.equals(this.include, other.include) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.require, other.require);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUMBER_OF_REPLICAS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), INCLUDE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), EXCLUDE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), REQUIRE_FIELD);
    }
}

