/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security;

import java.io.IOException;
import java.util.Arrays;
import org.easysearch.client.Validatable;
import org.easysearch.common.CharArrays;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

public final class ChangePasswordRequest
implements Validatable,
ToXContentObject {
    private final char[] password;
    private final char[] currentPassword;

    public ChangePasswordRequest(char[] password, char[] currentPassword) {
        this.password = password;
        this.currentPassword = currentPassword;
    }

    public char[] getPassword() {
        return this.password;
    }

    public char[] getCurrentPassword() {
        return this.currentPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        byte[] charBytes = CharArrays.toUtf8Bytes(this.password);
        byte[] currentPasswordBytes = CharArrays.toUtf8Bytes(this.currentPassword);
        try {
            XContentBuilder xContentBuilder = builder.startObject().field("password").utf8Value(charBytes, 0, charBytes.length).field("current_password").utf8Value(currentPasswordBytes, 0, currentPasswordBytes.length).endObject();
            return xContentBuilder;
        }
        finally {
            Arrays.fill(charBytes, (byte)0);
            Arrays.fill(currentPasswordBytes, (byte)0);
        }
    }
}

