/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.easysearch.client.Validatable;
import org.easysearch.client.ValidationException;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

public final class DelegatePkiAuthenticationRequest
implements Validatable,
ToXContentObject {
    private final List<X509Certificate> x509CertificateChain;

    public DelegatePkiAuthenticationRequest(List<X509Certificate> x509CertificateChain) {
        if (x509CertificateChain == null || x509CertificateChain.isEmpty()) {
            throw new IllegalArgumentException("certificate chain must not be empty or null");
        }
        this.x509CertificateChain = Collections.unmodifiableList(x509CertificateChain);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().startArray("x509_certificate_chain");
        try {
            for (X509Certificate cert : this.x509CertificateChain) {
                builder.value(Base64.getEncoder().encodeToString(cert.getEncoded()));
            }
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e);
        }
        return builder.endArray().endObject();
    }

    public List<X509Certificate> getCertificateChain() {
        return this.x509CertificateChain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatePkiAuthenticationRequest that = (DelegatePkiAuthenticationRequest)o;
        return Objects.equals(this.x509CertificateChain, that.x509CertificateChain);
    }

    public int hashCode() {
        return Objects.hash(this.x509CertificateChain);
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (!DelegatePkiAuthenticationRequest.isOrderedCertificateChain(this.x509CertificateChain)) {
            validationException.addValidationError("certificates chain must be an ordered chain");
        }
        return validationException.validationErrors().isEmpty() ? Optional.empty() : Optional.of(validationException);
    }

    private static boolean isOrderedCertificateChain(List<X509Certificate> chain) {
        for (int i = 1; i < chain.size(); ++i) {
            X509Certificate cert = chain.get(i - 1);
            X509Certificate issuer = chain.get(i);
            if (cert.getIssuerX500Principal().equals(issuer.getSubjectX500Principal())) continue;
            return false;
        }
        return true;
    }
}

