/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.security.user.privileges;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Privilege {
    @JsonIgnore
    private String name;
    private boolean reserved;
    private boolean hidden;
    private Set<String> privileges;
    private String type;
    private String description;
    @JsonProperty(value="static")
    private boolean _static;

    public Privilege(String name, Collection<String> privileges, String description) {
        this(name, false, false, false, privileges, null, description);
    }

    public Privilege(String name, boolean reserved, boolean hidden, boolean _static, Collection<String> privileges, String type, String description) {
        this.name = name;
        this.reserved = reserved;
        this.hidden = hidden;
        if (privileges == null || privileges.isEmpty()) {
            throw new IllegalArgumentException("privileges must be provided");
        }
        this.privileges = Collections.unmodifiableSet(new HashSet<String>(privileges));
        this._static = _static;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReserved() {
        return this.reserved;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Set<String> getPrivileges() {
        return this.privileges;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean is_static() {
        return this._static;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Privilege p = (Privilege)o;
        return this.reserved == p.reserved && this.hidden == p.hidden && this._static == p._static && this.name.equals(p.name) && Objects.equals(this.privileges, p.privileges) && Objects.equals(this.description, p.description) && Objects.equals(this.type, p.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.reserved, this.hidden, this._static, this.privileges, this.description, this.type);
    }
}

