/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.client.watcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.easysearch.client.Validatable;
import org.easysearch.common.Nullable;
import org.easysearch.common.bytes.BytesArray;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentType;

public class ExecuteWatchRequest
implements Validatable,
ToXContentObject {
    private final String id;
    private final BytesReference watchContent;
    private boolean ignoreCondition = false;
    private boolean recordExecution = false;
    private boolean debug = false;
    @Nullable
    private BytesReference triggerData = null;
    @Nullable
    private BytesReference alternativeInput = null;
    private Map<String, ActionExecutionMode> actionModes = new HashMap<String, ActionExecutionMode>();

    public static ExecuteWatchRequest byId(String id) {
        return new ExecuteWatchRequest(Objects.requireNonNull(id, "Watch id cannot be null"), null);
    }

    public static ExecuteWatchRequest inline(String watchContent) {
        return new ExecuteWatchRequest(null, Objects.requireNonNull(watchContent, "Watch content cannot be null"));
    }

    private ExecuteWatchRequest(String id, String watchContent) {
        this.id = id;
        this.watchContent = watchContent == null ? null : new BytesArray(watchContent);
    }

    public String getId() {
        return this.id;
    }

    public void setIgnoreCondition(boolean ignoreCondition) {
        this.ignoreCondition = ignoreCondition;
    }

    public boolean ignoreCondition() {
        return this.ignoreCondition;
    }

    public void setRecordExecution(boolean recordExecution) {
        if (this.watchContent != null && recordExecution) {
            throw new IllegalArgumentException("The execution of an inline watch cannot be recorded");
        }
        this.recordExecution = recordExecution;
    }

    public boolean recordExecution() {
        return this.recordExecution;
    }

    public void setAlternativeInput(String alternativeInput) {
        this.alternativeInput = new BytesArray(alternativeInput);
    }

    public void setTriggerData(String data) {
        this.triggerData = new BytesArray(data);
    }

    public void setActionMode(String actionId, ActionExecutionMode actionMode) {
        Objects.requireNonNull(actionId, "actionId cannot be null");
        this.actionModes.put(actionId, actionMode);
    }

    public Map<String, ActionExecutionMode> getActionModes() {
        return this.actionModes;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String toString() {
        return "execute[" + this.id + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.triggerData != null) {
            builder.rawField("trigger_data", this.triggerData.streamInput(), XContentType.JSON);
        }
        if (this.alternativeInput != null) {
            builder.rawField("alternative_input", this.alternativeInput.streamInput(), XContentType.JSON);
        }
        if (this.actionModes.size() > 0) {
            builder.field("action_modes", this.actionModes);
        }
        if (this.watchContent != null) {
            builder.rawField("watch", this.watchContent.streamInput(), XContentType.JSON);
        }
        builder.endObject();
        return builder;
    }

    public static enum ActionExecutionMode {
        SIMULATE,
        FORCE_SIMULATE,
        EXECUTE,
        FORCE_EXECUTE,
        SKIP;

    }
}

