/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.coordination;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.easysearch.action.ActionListener;
import org.easysearch.cluster.ClusterName;
import org.easysearch.cluster.ClusterState;
import org.easysearch.cluster.coordination.CoordinationMetadata;
import org.easysearch.cluster.coordination.Coordinator;
import org.easysearch.cluster.coordination.JoinHelper;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.common.Nullable;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.settings.Setting;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.common.util.concurrent.ConcurrentCollections;
import org.easysearch.common.util.concurrent.CountDown;
import org.easysearch.discovery.zen.ElectMasterService;
import org.easysearch.discovery.zen.UnicastZenPing;
import org.easysearch.discovery.zen.ZenDiscovery;
import org.easysearch.discovery.zen.ZenPing;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportException;
import org.easysearch.transport.TransportRequest;
import org.easysearch.transport.TransportRequestOptions;
import org.easysearch.transport.TransportResponseHandler;
import org.easysearch.transport.TransportService;

public class DiscoveryUpgradeService {
    private static Logger logger = LogManager.getLogger(DiscoveryUpgradeService.class);
    public static final Setting<TimeValue> BWC_PING_TIMEOUT_SETTING = Setting.timeSetting("discovery.zen.bwc_ping_timeout", ZenDiscovery.PING_TIMEOUT_SETTING, TimeValue.timeValueMillis(1L), Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<Boolean> ENABLE_UNSAFE_BOOTSTRAPPING_ON_UPGRADE_SETTING = Setting.boolSetting("discovery.zen.unsafe_rolling_upgrades_enabled", true, Setting.Property.NodeScope, Setting.Property.Deprecated);
    private static final ElectMasterService electMasterService = new ElectMasterService(Settings.EMPTY);
    private final TransportService transportService;
    private final BooleanSupplier isBootstrappedSupplier;
    private final JoinHelper joinHelper;
    private final Supplier<Iterable<DiscoveryNode>> peersSupplier;
    private final Consumer<CoordinationMetadata.VotingConfiguration> initialConfigurationConsumer;
    private final TimeValue bwcPingTimeout;
    private final boolean enableUnsafeBootstrappingOnUpgrade;
    private final ClusterName clusterName;
    @Nullable
    private volatile JoiningRound joiningRound;

    public DiscoveryUpgradeService(Settings settings, TransportService transportService, BooleanSupplier isBootstrappedSupplier, JoinHelper joinHelper, Supplier<Iterable<DiscoveryNode>> peersSupplier, Consumer<CoordinationMetadata.VotingConfiguration> initialConfigurationConsumer) {
        this.transportService = transportService;
        this.isBootstrappedSupplier = isBootstrappedSupplier;
        this.joinHelper = joinHelper;
        this.peersSupplier = peersSupplier;
        this.initialConfigurationConsumer = initialConfigurationConsumer;
        this.bwcPingTimeout = BWC_PING_TIMEOUT_SETTING.get(settings);
        this.enableUnsafeBootstrappingOnUpgrade = ENABLE_UNSAFE_BOOTSTRAPPING_ON_UPGRADE_SETTING.get(settings);
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
    }

    public void activate(Optional<DiscoveryNode> lastKnownLeader, ClusterState lastAcceptedClusterState) {
        int minimumMasterNodes;
        if (this.isBootstrappedSupplier.getAsBoolean()) {
            return;
        }
        assert (!lastKnownLeader.isPresent() || Coordinator.isZen1Node(lastKnownLeader.get())) : lastKnownLeader;
        Settings dynamicSettings = lastAcceptedClusterState.metadata().settings();
        int n = minimumMasterNodes = ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.exists(dynamicSettings) ? ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.get(dynamicSettings).intValue() : lastAcceptedClusterState.getMinimumMasterNodesOnPublishingMaster();
        assert (this.joiningRound == null) : this.joiningRound;
        HashSet<String> knownMasterNodeIds = new HashSet<String>();
        lastAcceptedClusterState.nodes().getMasterNodes().forEach(c -> knownMasterNodeIds.add((String)c.key));
        this.joiningRound = new JoiningRound(this.enableUnsafeBootstrappingOnUpgrade && lastKnownLeader.isPresent(), minimumMasterNodes, knownMasterNodeIds);
        this.joiningRound.scheduleNextAttempt();
    }

    public void deactivate() {
        this.joiningRound = null;
    }

    public static DiscoveryNode createDiscoveryNodeWithImpossiblyHighId(DiscoveryNode node) {
        return new DiscoveryNode(node.getName(), "{zen2}" + node.getId(), node.getEphemeralId(), node.getHostName(), node.getHostAddress(), node.getAddress(), node.getAttributes(), node.getRoles(), node.getVersion());
    }

    private class JoiningRound {
        private final boolean upgrading;
        private final int minimumMasterNodes;
        private final Set<String> knownMasterNodeIds;

        JoiningRound(boolean upgrading, int minimumMasterNodes, Set<String> knownMasterNodeIds) {
            this.upgrading = upgrading;
            this.minimumMasterNodes = minimumMasterNodes;
            this.knownMasterNodeIds = knownMasterNodeIds;
        }

        private boolean isRunning() {
            return DiscoveryUpgradeService.this.joiningRound == this && !DiscoveryUpgradeService.this.isBootstrappedSupplier.getAsBoolean();
        }

        private boolean canBootstrap(Set<DiscoveryNode> discoveryNodes) {
            return this.upgrading && (long)this.minimumMasterNodes <= discoveryNodes.stream().filter(DiscoveryNode::isMasterNode).count();
        }

        void scheduleNextAttempt() {
            if (!this.isRunning()) {
                return;
            }
            ThreadPool threadPool = DiscoveryUpgradeService.this.transportService.getThreadPool();
            threadPool.scheduleUnlessShuttingDown(DiscoveryUpgradeService.this.bwcPingTimeout, "same", new Runnable(){

                @Override
                public void run() {
                    if (!JoiningRound.this.isRunning()) {
                        return;
                    }
                    Set<DiscoveryNode> discoveryNodes = Stream.concat(StreamSupport.stream(DiscoveryUpgradeService.this.peersSupplier.get().spliterator(), false), Stream.of(DiscoveryUpgradeService.this.transportService.getLocalNode())).filter(DiscoveryNode::isMasterNode).collect(Collectors.toSet());
                    logger.debug("upgrading={}, minimumMasterNodes={}, nodes={}", (Object)JoiningRound.this.upgrading, (Object)JoiningRound.this.minimumMasterNodes, discoveryNodes);
                    if (discoveryNodes.stream().anyMatch(Coordinator::isZen1Node)) {
                        this.electBestOldMaster(discoveryNodes);
                    } else if (JoiningRound.this.canBootstrap(discoveryNodes)) {
                        DiscoveryUpgradeService.this.transportService.getThreadPool().generic().execute(() -> {
                            try {
                                HashSet<String> nodeIds = new HashSet<String>();
                                discoveryNodes.forEach(n -> nodeIds.add(n.getId()));
                                Iterator<String> knownNodeIdIterator = JoiningRound.this.knownMasterNodeIds.iterator();
                                while (nodeIds.size() < 2 * JoiningRound.this.minimumMasterNodes - 1 && knownNodeIdIterator.hasNext()) {
                                    nodeIds.add(knownNodeIdIterator.next());
                                }
                                CoordinationMetadata.VotingConfiguration votingConfiguration = new CoordinationMetadata.VotingConfiguration(nodeIds);
                                assert (votingConfiguration.hasQuorum(discoveryNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toList())));
                                assert (2 * JoiningRound.this.minimumMasterNodes - 2 <= nodeIds.size()) : nodeIds + " too small for " + JoiningRound.this.minimumMasterNodes;
                                DiscoveryUpgradeService.this.initialConfigurationConsumer.accept(votingConfiguration);
                            }
                            catch (Exception e) {
                                logger.debug("exception during bootstrapping upgrade, retrying", (Throwable)e);
                            }
                            finally {
                                JoiningRound.this.scheduleNextAttempt();
                            }
                        });
                    } else {
                        JoiningRound.this.scheduleNextAttempt();
                    }
                }

                private void electBestOldMaster(final Set<DiscoveryNode> discoveryNodes) {
                    final Set masterCandidates = ConcurrentCollections.newConcurrentSet();
                    final ListenableCountDown listenableCountDown = new ListenableCountDown(discoveryNodes.size(), new ActionListener<Void>(){

                        @Override
                        public void onResponse(Void value) {
                            assert (masterCandidates.size() == discoveryNodes.size()) : masterCandidates + " does not match " + discoveryNodes;
                            if (JoiningRound.this.isRunning()) {
                                ElectMasterService.MasterCandidate electedMaster = electMasterService.electMaster(masterCandidates);
                                logger.debug("elected {}, sending join", (Object)electedMaster);
                                DiscoveryUpgradeService.this.joinHelper.sendJoinRequest(electedMaster.getNode(), 0L, Optional.empty(), JoiningRound.this::scheduleNextAttempt);
                            }
                        }

                        @Override
                        public void onFailure(Exception e) {
                            JoiningRound.this.scheduleNextAttempt();
                        }
                    });
                    boolean foundOldMaster = false;
                    for (final DiscoveryNode discoveryNode : discoveryNodes) {
                        assert (discoveryNode.isMasterNode()) : discoveryNode;
                        if (Coordinator.isZen1Node(discoveryNode)) {
                            foundOldMaster = true;
                            DiscoveryUpgradeService.this.transportService.sendRequest(discoveryNode, "internal:discovery/zen/unicast", (TransportRequest)new UnicastZenPing.UnicastPingRequest(0, TimeValue.ZERO, new ZenPing.PingResponse(DiscoveryUpgradeService.createDiscoveryNodeWithImpossiblyHighId(DiscoveryUpgradeService.this.transportService.getLocalNode()), null, DiscoveryUpgradeService.this.clusterName, -1L)), TransportRequestOptions.builder().withTimeout(DiscoveryUpgradeService.this.bwcPingTimeout).build(), new TransportResponseHandler<UnicastZenPing.UnicastPingResponse>(){

                                @Override
                                public void handleResponse(UnicastZenPing.UnicastPingResponse response) {
                                    long clusterStateVersion = -1L;
                                    for (ZenPing.PingResponse pingResponse : response.pingResponses) {
                                        if (!discoveryNode.equals(pingResponse.node())) continue;
                                        clusterStateVersion = Math.max(clusterStateVersion, pingResponse.getClusterStateVersion());
                                    }
                                    masterCandidates.add(new ElectMasterService.MasterCandidate(discoveryNode, clusterStateVersion));
                                    listenableCountDown.countDown();
                                }

                                @Override
                                public void handleException(TransportException exp) {
                                    logger.debug((Message)new ParameterizedMessage("unexpected exception when pinging {}", (Object)discoveryNode), (Throwable)exp);
                                    listenableCountDown.onFailure(exp);
                                }

                                @Override
                                public String executor() {
                                    return "same";
                                }

                                @Override
                                public UnicastZenPing.UnicastPingResponse read(StreamInput in) throws IOException {
                                    return new UnicastZenPing.UnicastPingResponse(in);
                                }
                            });
                            continue;
                        }
                        masterCandidates.add(new ElectMasterService.MasterCandidate(DiscoveryUpgradeService.createDiscoveryNodeWithImpossiblyHighId(discoveryNode), -1L));
                        listenableCountDown.countDown();
                    }
                    assert (foundOldMaster);
                }

                public String toString() {
                    return "discovery upgrade service retry";
                }
            });
        }
    }

    private static class ListenableCountDown {
        private final CountDown countDown;
        private final ActionListener<Void> listener;

        ListenableCountDown(int count, ActionListener<Void> listener) {
            this.countDown = new CountDown(count);
            this.listener = listener;
        }

        void onFailure(Exception e) {
            if (this.countDown.fastForward()) {
                this.listener.onFailure(e);
            }
        }

        void countDown() {
            if (this.countDown.countDown()) {
                this.listener.onResponse(null);
            }
        }
    }
}

