/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.routing;

import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.CollectionUtil;
import org.easysearch.common.util.Countable;

public final class GroupShardsIterator<ShardIt extends Comparable<ShardIt> & Countable>
implements Iterable<ShardIt> {
    private final List<ShardIt> iterators;

    public static <ShardIt extends Comparable<ShardIt> & Countable> GroupShardsIterator<ShardIt> sortAndCreate(List<ShardIt> iterators) {
        CollectionUtil.timSort(iterators);
        return new GroupShardsIterator<ShardIt>(iterators);
    }

    public GroupShardsIterator(List<ShardIt> iterators) {
        this.iterators = iterators;
    }

    public int totalSize() {
        return this.iterators.stream().mapToInt(rec$ -> ((Countable)rec$).size()).sum();
    }

    public int totalSizeWith1ForEmpty() {
        int size = 0;
        for (Comparable shard : this.iterators) {
            size += Math.max(1, ((Countable)((Object)shard)).size());
        }
        return size;
    }

    public int size() {
        return this.iterators.size();
    }

    @Override
    public Iterator<ShardIt> iterator() {
        return this.iterators.iterator();
    }

    public ShardIt get(int index) {
        return (ShardIt)((Comparable)this.iterators.get(index));
    }
}

