/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.routing;

import org.apache.lucene.util.StringHelper;

public final class Murmur3HashFunction {
    private Murmur3HashFunction() {
    }

    public static int hash(String routing) {
        byte[] bytesToHash = new byte[routing.length() * 2];
        for (int i = 0; i < routing.length(); ++i) {
            char c = routing.charAt(i);
            byte b1 = (byte)c;
            byte b2 = (byte)(c >>> 8);
            assert ((b1 & 0xFF | (b2 & 0xFF) << 8) == c);
            bytesToHash[i * 2] = b1;
            bytesToHash[i * 2 + 1] = b2;
        }
        return Murmur3HashFunction.hash(bytesToHash, 0, bytesToHash.length);
    }

    public static int hash(byte[] bytes, int offset, int length) {
        return StringHelper.murmurhash3_x86_32((byte[])bytes, (int)offset, (int)length, (int)0);
    }
}

