/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.cluster.routing.allocation.command;

import java.io.IOException;
import java.util.Optional;
import org.easysearch.cluster.node.DiscoveryNode;
import org.easysearch.cluster.routing.RecoverySource;
import org.easysearch.cluster.routing.RoutingNode;
import org.easysearch.cluster.routing.RoutingNodes;
import org.easysearch.cluster.routing.ShardRouting;
import org.easysearch.cluster.routing.allocation.RerouteExplanation;
import org.easysearch.cluster.routing.allocation.RoutingAllocation;
import org.easysearch.cluster.routing.allocation.command.BasePrimaryAllocationCommand;
import org.easysearch.cluster.routing.allocation.decider.Decision;
import org.easysearch.common.ParseField;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.xcontent.ObjectParser;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.index.IndexNotFoundException;
import org.easysearch.index.shard.ShardNotFoundException;

public class AllocateStalePrimaryAllocationCommand
extends BasePrimaryAllocationCommand {
    public static final String NAME = "allocate_stale_primary";
    public static final ParseField COMMAND_NAME_FIELD = new ParseField("allocate_stale_primary", new String[0]);
    private static final ObjectParser<Builder, Void> STALE_PRIMARY_PARSER = BasePrimaryAllocationCommand.createAllocatePrimaryParser("allocate_stale_primary");

    public AllocateStalePrimaryAllocationCommand(String index, int shardId, String node, boolean acceptDataLoss) {
        super(index, shardId, node, acceptDataLoss);
    }

    public AllocateStalePrimaryAllocationCommand(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Optional<String> getMessage() {
        return Optional.of("allocated a stale primary for [" + this.index + "][" + this.shardId + "] on node [" + this.node + "] from user command");
    }

    public static AllocateStalePrimaryAllocationCommand fromXContent(XContentParser parser) throws IOException {
        return new Builder().parse(parser).build();
    }

    @Override
    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) {
        DiscoveryNode discoNode;
        try {
            discoNode = allocation.nodes().resolveNode(this.node);
        }
        catch (IllegalArgumentException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNode routingNode = routingNodes.node(discoNode.getId());
        if (routingNode == null) {
            return this.explainOrThrowMissingRoutingNode(allocation, explain, discoNode);
        }
        try {
            allocation.routingTable().shardRoutingTable(this.index, this.shardId).primaryShard();
        }
        catch (IndexNotFoundException | ShardNotFoundException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        ShardRouting shardRouting = null;
        for (ShardRouting shard : allocation.routingNodes().unassigned()) {
            if (!shard.getIndexName().equals(this.index) || shard.getId() != this.shardId || !shard.primary()) continue;
            shardRouting = shard;
            break;
        }
        if (shardRouting == null) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "primary [" + this.index + "][" + this.shardId + "] is already assigned");
        }
        if (!this.acceptDataLoss) {
            String dataLossWarning = "allocating an empty primary for [" + this.index + "][" + this.shardId + "] can result in data loss. Please confirm by setting the accept_data_loss parameter to true";
            return this.explainOrThrowRejectedCommand(explain, allocation, dataLossWarning);
        }
        if (shardRouting.recoverySource().getType() != RecoverySource.Type.EXISTING_STORE) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "trying to allocate an existing primary shard [" + this.index + "][" + this.shardId + "], while no such shard has ever been active");
        }
        this.initializeUnassignedShard(allocation, routingNodes, routingNode, shardRouting, null, RecoverySource.ExistingStoreRecoverySource.FORCE_STALE_PRIMARY_INSTANCE);
        return new RerouteExplanation(this, allocation.decision(Decision.YES, this.name() + " (allocation command)", "ignore deciders", new Object[0]));
    }

    public static class Builder
    extends BasePrimaryAllocationCommand.Builder<AllocateStalePrimaryAllocationCommand> {
        public Builder parse(XContentParser parser) throws IOException {
            return STALE_PRIMARY_PARSER.parse(parser, this, null);
        }

        @Override
        public AllocateStalePrimaryAllocationCommand build() {
            this.validate();
            return new AllocateStalePrimaryAllocationCommand(this.index, this.shard, this.node, this.acceptDataLoss);
        }
    }
}

