/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common;

import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import org.easysearch.common.MacAddressProvider;
import org.easysearch.common.SecureRandomHolder;
import org.easysearch.common.UUIDGenerator;

class LegacyTimeBasedUUIDGenerator
implements UUIDGenerator {
    private final AtomicInteger sequenceNumber = new AtomicInteger(SecureRandomHolder.INSTANCE.nextInt());
    private long lastTimestamp;
    private static final byte[] SECURE_MUNGED_ADDRESS = MacAddressProvider.getSecureMungedAddress();

    LegacyTimeBasedUUIDGenerator() {
    }

    private static void putLong(byte[] array, long l, int pos, int numberOfLongBytes) {
        for (int i = 0; i < numberOfLongBytes; ++i) {
            array[pos + numberOfLongBytes - i - 1] = (byte)(l >>> i * 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBase64UUID() {
        int sequenceId = this.sequenceNumber.incrementAndGet() & 0xFFFFFF;
        long timestamp = System.currentTimeMillis();
        LegacyTimeBasedUUIDGenerator legacyTimeBasedUUIDGenerator = this;
        synchronized (legacyTimeBasedUUIDGenerator) {
            timestamp = Math.max(this.lastTimestamp, timestamp);
            if (sequenceId == 0) {
                ++timestamp;
            }
            this.lastTimestamp = timestamp;
        }
        byte[] uuidBytes = new byte[15];
        LegacyTimeBasedUUIDGenerator.putLong(uuidBytes, timestamp, 0, 6);
        System.arraycopy(SECURE_MUNGED_ADDRESS, 0, uuidBytes, 6, SECURE_MUNGED_ADDRESS.length);
        LegacyTimeBasedUUIDGenerator.putLong(uuidBytes, sequenceId, 12, 3);
        assert (9 + SECURE_MUNGED_ADDRESS.length == uuidBytes.length);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(uuidBytes);
    }

    static {
        assert (SECURE_MUNGED_ADDRESS.length == 6);
    }
}

