/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.inject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.easysearch.common.inject.Key;
import org.easysearch.common.inject.Lookups;
import org.easysearch.common.inject.MembersInjector;
import org.easysearch.common.inject.Provider;
import org.easysearch.common.inject.TypeLiteral;
import org.easysearch.common.inject.internal.Errors;
import org.easysearch.common.inject.spi.InjectionListener;
import org.easysearch.common.inject.spi.Message;
import org.easysearch.common.inject.spi.TypeEncounter;

final class EncounterImpl<T>
implements TypeEncounter<T> {
    private final Errors errors;
    private final Lookups lookups;
    private List<MembersInjector<? super T>> membersInjectors;
    private List<InjectionListener<? super T>> injectionListeners;
    private boolean valid = true;

    EncounterImpl(Errors errors, Lookups lookups) {
        this.errors = errors;
        this.lookups = lookups;
    }

    public void invalidate() {
        this.valid = false;
    }

    public List<MembersInjector<? super T>> getMembersInjectors() {
        return this.membersInjectors == null ? Collections.emptyList() : Collections.unmodifiableList(this.membersInjectors);
    }

    public List<InjectionListener<? super T>> getInjectionListeners() {
        return this.injectionListeners == null ? Collections.emptyList() : Collections.unmodifiableList(this.injectionListeners);
    }

    @Override
    public void register(MembersInjector<? super T> membersInjector) {
        if (!this.valid) {
            throw new IllegalStateException("Encounters may not be used after hear() returns.");
        }
        if (this.membersInjectors == null) {
            this.membersInjectors = new ArrayList<MembersInjector<? super T>>();
        }
        this.membersInjectors.add(membersInjector);
    }

    @Override
    public void register(InjectionListener<? super T> injectionListener) {
        if (!this.valid) {
            throw new IllegalStateException("Encounters may not be used after hear() returns.");
        }
        if (this.injectionListeners == null) {
            this.injectionListeners = new ArrayList<InjectionListener<? super T>>();
        }
        this.injectionListeners.add(injectionListener);
    }

    @Override
    public void addError(String message, Object ... arguments) {
        if (!this.valid) {
            throw new IllegalStateException("Encounters may not be used after hear() returns.");
        }
        this.errors.addMessage(message, arguments);
    }

    @Override
    public void addError(Throwable t) {
        if (!this.valid) {
            throw new IllegalStateException("Encounters may not be used after hear() returns.");
        }
        this.errors.errorInUserCode(t, "An exception was caught and reported. Message: %s", t.getMessage());
    }

    @Override
    public void addError(Message message) {
        if (!this.valid) {
            throw new IllegalStateException("Encounters may not be used after hear() returns.");
        }
        this.errors.addMessage(message);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        if (!this.valid) {
            throw new IllegalStateException("Encounters may not be used after hear() returns.");
        }
        return this.lookups.getProvider(key);
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.getProvider(Key.get(type));
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        if (!this.valid) {
            throw new IllegalStateException("Encounters may not be used after hear() returns.");
        }
        return this.lookups.getMembersInjector(typeLiteral);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.getMembersInjector(TypeLiteral.get(type));
    }
}

