/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.inject.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.easysearch.common.inject.Binder;
import org.easysearch.common.inject.Injector;
import org.easysearch.common.inject.Key;
import org.easysearch.common.inject.PrivateBinder;
import org.easysearch.common.inject.internal.ExposureBuilder;
import org.easysearch.common.inject.internal.ToStringBuilder;
import org.easysearch.common.inject.spi.Element;
import org.easysearch.common.inject.spi.ElementVisitor;
import org.easysearch.common.inject.spi.PrivateElements;

public final class PrivateElementsImpl
implements PrivateElements {
    private final Object source;
    private List<Element> elementsMutable = new ArrayList<Element>();
    private List<ExposureBuilder<?>> exposureBuilders = new ArrayList();
    private List<Element> elements;
    private Map<Key<?>, Object> exposedKeysToSources;
    private Injector injector;

    public PrivateElementsImpl(Object source) {
        this.source = Objects.requireNonNull(source, "source");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public List<Element> getElements() {
        if (this.elements == null) {
            this.elements = Collections.unmodifiableList(this.elementsMutable);
            this.elementsMutable = null;
        }
        return this.elements;
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    public void initInjector(Injector injector) {
        if (this.injector != null) {
            throw new IllegalStateException("injector already initialized");
        }
        this.injector = Objects.requireNonNull(injector, "injector");
    }

    @Override
    public Set<Key<?>> getExposedKeys() {
        if (this.exposedKeysToSources == null) {
            LinkedHashMap exposedKeysToSourcesMutable = new LinkedHashMap();
            for (ExposureBuilder<?> exposureBuilder : this.exposureBuilders) {
                exposedKeysToSourcesMutable.put(exposureBuilder.getKey(), exposureBuilder.getSource());
            }
            this.exposedKeysToSources = Collections.unmodifiableMap(exposedKeysToSourcesMutable);
            this.exposureBuilders = null;
        }
        return this.exposedKeysToSources.keySet();
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public List<Element> getElementsMutable() {
        return this.elementsMutable;
    }

    public void addExposureBuilder(ExposureBuilder<?> exposureBuilder) {
        this.exposureBuilders.add(exposureBuilder);
    }

    @Override
    public void applyTo(Binder binder) {
        PrivateBinder privateBinder = binder.withSource(this.source).newPrivateBinder();
        for (Element element : this.getElements()) {
            element.applyTo(privateBinder);
        }
        this.getExposedKeys();
        for (Map.Entry entry : this.exposedKeysToSources.entrySet()) {
            privateBinder.withSource(entry.getValue()).expose((Key)entry.getKey());
        }
    }

    @Override
    public Object getExposedSource(Key<?> key) {
        this.getExposedKeys();
        Object source = this.exposedKeysToSources.get(key);
        if (source == null) {
            throw new IllegalArgumentException(key + " not exposed by .");
        }
        return source;
    }

    public String toString() {
        return new ToStringBuilder(PrivateElements.class).add("exposedKeys", this.getExposedKeys()).add("source", this.getSource()).toString();
    }
}

