/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.inject.spi;

import java.util.Objects;
import java.util.Set;
import org.easysearch.common.inject.Binder;
import org.easysearch.common.inject.ConfigurationException;
import org.easysearch.common.inject.spi.Element;
import org.easysearch.common.inject.spi.ElementVisitor;
import org.easysearch.common.inject.spi.InjectionPoint;

public final class StaticInjectionRequest
implements Element {
    private final Object source;
    private final Class<?> type;

    StaticInjectionRequest(Object source, Class<?> type) {
        this.source = Objects.requireNonNull(source, "source");
        this.type = Objects.requireNonNull(type, "type");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Set<InjectionPoint> getInjectionPoints() throws ConfigurationException {
        return InjectionPoint.forStaticMethodsAndFields(this.type);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).requestStaticInjection(this.type);
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

