/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class UTF8StreamWriter
extends Writer {
    private OutputStream _outputStream;
    private final byte[] _bytes;
    private int _index;
    private char _highSurrogate;

    public UTF8StreamWriter() {
        this._bytes = new byte[2048];
    }

    public UTF8StreamWriter(int capacity) {
        this._bytes = new byte[capacity];
    }

    public UTF8StreamWriter setOutput(OutputStream out) {
        if (this._outputStream != null) {
            throw new IllegalStateException("Writer not closed or reset");
        }
        this._outputStream = out;
        return this;
    }

    public void write(char c) throws IOException {
        if (c < '\ud800' || c > '\udfff') {
            this.write((int)c);
        } else if (c < '\udc00') {
            this._highSurrogate = c;
        } else {
            int code = (this._highSurrogate - 55296 << 10) + (c - 56320) + 65536;
            this.write(code);
        }
    }

    @Override
    public void write(int code) throws IOException {
        if ((code & 0xFFFFFF80) == 0) {
            this._bytes[this._index] = (byte)code;
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else {
            this.write2(code);
        }
    }

    private void write2(int c) throws IOException {
        if ((c & 0xFFFFF800) == 0) {
            this._bytes[this._index] = (byte)(0xC0 | c >> 6);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((c & 0xFFFF0000) == 0) {
            this._bytes[this._index] = (byte)(0xE0 | c >> 12);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((c & 0xFF200000) == 0) {
            this._bytes[this._index] = (byte)(0xF0 | c >> 18);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c >> 12 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((c & 0xF4000000) == 0) {
            this._bytes[this._index] = (byte)(0xF8 | c >> 24);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c >> 18 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c >> 12 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else if ((c & Integer.MIN_VALUE) == 0) {
            this._bytes[this._index] = (byte)(0xFC | c >> 30);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c >> 24 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c >> 18 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c >> 12 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c >> 6 & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
            this._bytes[this._index] = (byte)(0x80 | c & 0x3F);
            if (++this._index >= this._bytes.length) {
                this.flushBuffer();
            }
        } else {
            throw new CharConversionException("Illegal character U+" + Integer.toHexString(c));
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int off_plus_len = off + len;
        int i = off;
        while (i < off_plus_len) {
            char c;
            if ((c = cbuf[i++]) < '\u0080') {
                this._bytes[this._index] = (byte)c;
                if (++this._index < this._bytes.length) continue;
                this.flushBuffer();
                continue;
            }
            this.write(c);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int off_plus_len = off + len;
        int i = off;
        while (i < off_plus_len) {
            char c;
            if ((c = str.charAt(i++)) < '\u0080') {
                this._bytes[this._index] = (byte)c;
                if (++this._index < this._bytes.length) continue;
                this.flushBuffer();
                continue;
            }
            this.write(c);
        }
    }

    public void write(CharSequence csq) throws IOException {
        int length = csq.length();
        int i = 0;
        while (i < length) {
            char c;
            if ((c = csq.charAt(i++)) < '\u0080') {
                this._bytes[this._index] = (byte)c;
                if (++this._index < this._bytes.length) continue;
                this.flushBuffer();
                continue;
            }
            this.write(c);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this._outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._outputStream != null) {
            this.flushBuffer();
            this._outputStream.close();
            this.reset();
        }
    }

    private void flushBuffer() throws IOException {
        if (this._outputStream == null) {
            throw new IOException("Stream closed");
        }
        this._outputStream.write(this._bytes, 0, this._index);
        this._index = 0;
    }

    public void reset() {
        this._highSurrogate = '\u0000';
        this._index = 0;
        this._outputStream = null;
    }
}

