/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.settings;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Objects;

public final class SecureString
implements CharSequence,
Closeable {
    private char[] chars;

    public SecureString(char[] chars) {
        this.chars = Objects.requireNonNull(chars);
    }

    @Deprecated
    public SecureString(String s2) {
        this(s2.toCharArray());
    }

    public synchronized boolean equals(Object o) {
        this.ensureNotClosed();
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CharSequence)) {
            return false;
        }
        CharSequence that = (CharSequence)o;
        if (this.chars.length != that.length()) {
            return false;
        }
        int equals = 0;
        for (int i = 0; i < this.chars.length; ++i) {
            equals |= this.chars[i] ^ that.charAt(i);
        }
        return equals == 0;
    }

    public synchronized int hashCode() {
        return Arrays.hashCode(this.chars);
    }

    @Override
    public synchronized int length() {
        this.ensureNotClosed();
        return this.chars.length;
    }

    @Override
    public synchronized char charAt(int index) {
        this.ensureNotClosed();
        return this.chars[index];
    }

    @Override
    public SecureString subSequence(int start, int end) {
        throw new UnsupportedOperationException("Cannot get subsequence of SecureString");
    }

    @Override
    public synchronized String toString() {
        return new String(this.chars);
    }

    @Override
    public synchronized void close() {
        if (this.chars != null) {
            Arrays.fill(this.chars, '\u0000');
            this.chars = null;
        }
    }

    public synchronized SecureString clone() {
        this.ensureNotClosed();
        return new SecureString(Arrays.copyOf(this.chars, this.chars.length));
    }

    public synchronized char[] getChars() {
        this.ensureNotClosed();
        return this.chars;
    }

    private void ensureNotClosed() {
        if (this.chars == null) {
            throw new IllegalStateException("SecureString has already been closed");
        }
    }
}

