/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.common.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.BytesRef;
import org.easysearch.EasysearchParseException;
import org.easysearch.ExceptionsHelper;
import org.easysearch.common.bytes.BytesReference;
import org.easysearch.common.collect.Tuple;
import org.easysearch.common.xcontent.DeprecationHandler;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.common.xcontent.XContentHelper;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentType;
import org.easysearch.common.xcontent.json.JsonXContent;

public class JsonUtils {
    public static final ObjectMapper objectMapper = new ObjectMapper();
    static final String slash = "/";

    public static JsonNode convertJsonToJsonNode(String jsonContent) {
        try {
            return objectMapper.readTree(jsonContent);
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic(e1);
        }
    }

    public static String writeObjectAsString(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic(e1);
        }
    }

    public static JsonNode convertBytesToJsonNode(byte[] bytes, int offset, int length) {
        try {
            return objectMapper.readTree(bytes, offset, length);
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic(e1);
        }
    }

    public static JsonNode convertBytesRefToJsonNode(BytesRef bytesRef) {
        try {
            byte[] bytes = bytesRef.bytes;
            int offset = bytesRef.offset;
            int length = bytesRef.length;
            return objectMapper.readTree(bytes, offset, length);
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic(e1);
        }
    }

    public static JsonNode convertMapToJsonNode(Map<String, Object> map) {
        try {
            return objectMapper.valueToTree(map);
        }
        catch (Exception e1) {
            throw ExceptionsHelper.convertToElastic(e1);
        }
    }

    public static byte[] convertJsonNodeToBytes(JsonNode jsonNode) {
        try {
            return objectMapper.writeValueAsBytes((Object)jsonNode);
        }
        catch (IOException e1) {
            throw ExceptionsHelper.convertToElastic(e1);
        }
    }

    public static void GetNonObjectArrayPath(JsonNode node, String jsonPath, String newPath, Map<String, Tuple<String, JsonNode>> map) {
        if (node.isObject()) {
            Iterator it = node.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String jsonPath1 = jsonPath.isEmpty() ? (String)entry.getKey() : jsonPath + "." + (String)entry.getKey();
                String newPath1 = newPath.isEmpty() ? slash + (String)entry.getKey() : newPath + slash + (String)entry.getKey();
                JsonUtils.GetNonObjectArrayPath((JsonNode)entry.getValue(), jsonPath1, newPath1, map);
            }
        } else if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            if (!arrayNode.isEmpty()) {
                boolean b = true;
                for (JsonNode jsonNode : arrayNode) {
                    if (jsonNode.isValueNode()) continue;
                    b = false;
                    break;
                }
                if (b) {
                    map.put(jsonPath, Tuple.tuple(newPath, node));
                }
            }
        } else {
            map.put(jsonPath, Tuple.tuple(newPath, node));
        }
    }

    public static void GetAllPath(JsonNode node, String jsonPath, Set<String> set) {
        if (node.isObject()) {
            node.fields().forEachRemaining(entry -> {
                String newPath = jsonPath.isEmpty() ? (String)entry.getKey() : jsonPath + "." + (String)entry.getKey();
                JsonUtils.GetAllPath((JsonNode)entry.getValue(), newPath, set);
            });
        } else if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonUtils.GetAllPath(arrayNode.get(i), jsonPath, set);
            }
        } else {
            set.add(jsonPath);
        }
    }

    public static JsonNode nestedJson(JsonNode flatJsonNode) {
        ObjectNode nestedJsonNode = objectMapper.createObjectNode();
        Iterator fieldsIterator = flatJsonNode.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            String[] path = ((String)field.getKey()).split("\\.");
            ObjectNode currentNode = nestedJsonNode;
            for (int i = 0; i < path.length - 1; ++i) {
                currentNode = currentNode.with(path[i]);
            }
            currentNode.set(path[path.length - 1], (JsonNode)field.getValue());
        }
        return nestedJsonNode;
    }

    public static Map<String, Object> convertJsonToxToStructuredMap(String jsonContent) {
        Map<String, Object> map;
        block8: {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, jsonContent);
            try {
                map = parser.map();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e1) {
                    throw ExceptionsHelper.convertToElastic(e1);
                }
            }
            parser.close();
        }
        return map;
    }

    public static String convertStructuredMapToJson(Map<String, Object> structuredMap) {
        try {
            return XContentHelper.convertToJson(JsonUtils.convertStructuredMapToBytes(structuredMap), false, XContentType.JSON);
        }
        catch (IOException e) {
            throw new EasysearchParseException("Failed to convert map", (Throwable)e, new Object[0]);
        }
    }

    public static BytesReference convertStructuredMapToBytes(Map<String, Object> structuredMap) {
        try {
            return BytesReference.bytes(JsonXContent.contentBuilder().map(structuredMap));
        }
        catch (IOException e) {
            throw new EasysearchParseException("Failed to convert map", (Throwable)e, new Object[0]);
        }
    }

    public static Map<String, Object> flattenJson(JsonNode node) {
        LinkedHashMap<String, Object> flatMap = new LinkedHashMap<String, Object>();
        JsonUtils.flatten(node, "", flatMap);
        return flatMap;
    }

    private static void flatten(JsonNode node, String prefix, Map<String, Object> flatMap) {
        if (node.isObject()) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                String fieldName = (String)field.getKey();
                JsonNode childNode = (JsonNode)field.getValue();
                JsonUtils.flatten(childNode, (String)(prefix.isEmpty() ? fieldName : prefix + "." + fieldName), flatMap);
            }
        } else if (node.isArray()) {
            flatMap.put(prefix, node);
        } else {
            flatMap.put(prefix, node.asText());
        }
    }
}

