/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.discovery;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.easysearch.common.settings.Setting;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.transport.TransportAddress;
import org.easysearch.discovery.SeedHostsProvider;
import org.easysearch.transport.TransportService;

public class SettingsBasedSeedHostsProvider
implements SeedHostsProvider {
    private static final Logger logger = LogManager.getLogger(SettingsBasedSeedHostsProvider.class);
    public static final Setting<List<String>> LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING = Setting.listSetting("discovery.zen.ping.unicast.hosts", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<List<String>> DISCOVERY_SEED_HOSTS_SETTING = Setting.listSetting("discovery.seed_hosts", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    private final List<String> configuredHosts;

    public SettingsBasedSeedHostsProvider(Settings settings, TransportService transportService) {
        if (LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING.exists(settings)) {
            if (DISCOVERY_SEED_HOSTS_SETTING.exists(settings)) {
                throw new IllegalArgumentException("it is forbidden to set both [" + DISCOVERY_SEED_HOSTS_SETTING.getKey() + "] and [" + LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING.getKey() + "]");
            }
            this.configuredHosts = LEGACY_DISCOVERY_ZEN_PING_UNICAST_HOSTS_SETTING.get(settings);
        } else {
            this.configuredHosts = DISCOVERY_SEED_HOSTS_SETTING.exists(settings) ? DISCOVERY_SEED_HOSTS_SETTING.get(settings) : transportService.getDefaultSeedAddresses();
        }
        logger.debug("using initial hosts {}", this.configuredHosts);
    }

    @Override
    public List<TransportAddress> getSeedAddresses(SeedHostsProvider.HostsResolver hostsResolver) {
        return hostsResolver.resolveHosts(this.configuredHosts);
    }
}

