/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.easysearch.Version;
import org.easysearch.common.lucene.Lucene;
import org.easysearch.common.lucene.index.EasysearchDirectoryReader;
import org.easysearch.common.util.concurrent.ReleasableLock;
import org.easysearch.core.internal.io.IOUtils;
import org.easysearch.index.engine.CompletionStatsCache;
import org.easysearch.index.engine.EasysearchReaderManager;
import org.easysearch.index.engine.Engine;
import org.easysearch.index.engine.EngineConfig;
import org.easysearch.index.engine.EngineException;
import org.easysearch.index.engine.RamAccountingRefreshListener;
import org.easysearch.index.engine.SafeCommitInfo;
import org.easysearch.index.engine.Segment;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.seqno.SeqNoStats;
import org.easysearch.index.seqno.SequenceNumbers;
import org.easysearch.index.store.Store;
import org.easysearch.index.translog.DefaultTranslogDeletionPolicy;
import org.easysearch.index.translog.Translog;
import org.easysearch.index.translog.TranslogConfig;
import org.easysearch.index.translog.TranslogStats;
import org.easysearch.search.suggest.completion.CompletionStats;
import org.easysearch.transport.Transports;

public class ReadOnlyEngine
extends Engine {
    private final SegmentInfos lastCommittedSegmentInfos;
    private final SeqNoStats seqNoStats;
    private final EasysearchReaderManager readerManager;
    private final IndexCommit indexCommit;
    private final Lock indexWriterLock;
    private final RamAccountingRefreshListener refreshListener;
    private final SafeCommitInfo safeCommitInfo;
    private final CompletionStatsCache completionStatsCache;
    private final boolean requireCompleteHistory;
    protected volatile TranslogStats translogStats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReadOnlyEngine(EngineConfig config, SeqNoStats seqNoStats, TranslogStats translogStats, boolean obtainLock, Function<DirectoryReader, DirectoryReader> readerWrapperFunction, boolean requireCompleteHistory) {
        super(config);
        this.refreshListener = new RamAccountingRefreshListener(this.engineConfig.getCircuitBreakerService());
        this.requireCompleteHistory = requireCompleteHistory;
        try {
            Store store = config.getStore();
            store.incRef();
            EasysearchDirectoryReader reader = null;
            Directory directory = store.directory();
            Lock indexWriterLock = null;
            boolean success = false;
            try {
                indexWriterLock = obtainLock ? directory.obtainLock("write.lock") : null;
                this.lastCommittedSegmentInfos = Lucene.readSegmentInfos(directory);
                if (seqNoStats == null) {
                    seqNoStats = ReadOnlyEngine.buildSeqNoStats(config, this.lastCommittedSegmentInfos);
                    this.ensureMaxSeqNoEqualsToGlobalCheckpoint(seqNoStats);
                }
                this.seqNoStats = seqNoStats;
                this.indexCommit = Lucene.getIndexCommit(this.lastCommittedSegmentInfos, directory);
                reader = this.wrapReader(this.open(this.indexCommit), readerWrapperFunction);
                this.readerManager = new EasysearchReaderManager(reader, this.refreshListener);
                assert (translogStats != null || obtainLock) : "mutiple translogs instances should not be opened at the same time";
                this.translogStats = translogStats != null ? translogStats : ReadOnlyEngine.translogStats(config, this.lastCommittedSegmentInfos);
                this.indexWriterLock = indexWriterLock;
                this.safeCommitInfo = new SafeCommitInfo(seqNoStats.getLocalCheckpoint(), this.lastCommittedSegmentInfos.totalMaxDoc());
                this.completionStatsCache = new CompletionStatsCache(() -> this.acquireSearcher("completion_stats"));
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = reader;
                closeableArray[1] = indexWriterLock;
                closeableArray[2] = store::decRef;
                IOUtils.close(closeableArray);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void ensureMaxSeqNoEqualsToGlobalCheckpoint(SeqNoStats seqNoStats) {
        if (!this.requireCompleteHistory) {
            return;
        }
        Version indexVersionCreated = this.engineConfig.getIndexSettings().getIndexVersionCreated();
        if (seqNoStats.getGlobalCheckpoint() != -2L) {
            assert (this.assertMaxSeqNoEqualsToGlobalCheckpoint(seqNoStats.getMaxSeqNo(), seqNoStats.getGlobalCheckpoint()));
            if (seqNoStats.getMaxSeqNo() != seqNoStats.getGlobalCheckpoint()) {
                throw new IllegalStateException("Maximum sequence number [" + seqNoStats.getMaxSeqNo() + "] from last commit does not match global checkpoint [" + seqNoStats.getGlobalCheckpoint() + "]");
            }
        }
    }

    protected boolean assertMaxSeqNoEqualsToGlobalCheckpoint(long maxSeqNo, long globalCheckpoint) {
        assert (maxSeqNo == globalCheckpoint) : "max seq. no. [" + maxSeqNo + "] does not match [" + globalCheckpoint + "]";
        return true;
    }

    @Override
    public void verifyEngineBeforeIndexClosing() throws IllegalStateException {
    }

    protected final EasysearchDirectoryReader wrapReader(DirectoryReader reader, Function<DirectoryReader, DirectoryReader> readerWrapperFunction) throws IOException {
        if (this.engineConfig.getIndexSettings().isSoftDeleteEnabled()) {
            reader = new SoftDeletesDirectoryReaderWrapper(reader, "__soft_deletes");
        }
        reader = readerWrapperFunction.apply(reader);
        return EasysearchDirectoryReader.wrap(reader, this.engineConfig.getShardId());
    }

    protected DirectoryReader open(IndexCommit commit) throws IOException {
        assert (Transports.assertNotTransportThread("opening index commit of a read-only engine"));
        return DirectoryReader.open((IndexCommit)commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = this.readerManager;
                closeableArray[1] = this.indexWriterLock;
                closeableArray[2] = this.store::decRef;
                IOUtils.close(closeableArray);
            }
            catch (Exception ex) {
                this.logger.warn("failed to close reader", (Throwable)ex);
            }
            finally {
                closedLatch.countDown();
            }
        }
    }

    private static SeqNoStats buildSeqNoStats(EngineConfig config, SegmentInfos infos) {
        SequenceNumbers.CommitInfo seqNoStats = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(infos.userData.entrySet());
        long maxSeqNo = seqNoStats.maxSeqNo;
        long localCheckpoint = seqNoStats.localCheckpoint;
        return new SeqNoStats(maxSeqNo, localCheckpoint, config.getGlobalCheckpointSupplier().getAsLong());
    }

    private static TranslogStats translogStats(EngineConfig config, SegmentInfos infos) throws IOException {
        String translogUuid = (String)infos.getUserData().get("translog_uuid");
        if (translogUuid == null) {
            throw new IllegalStateException("commit doesn't contain translog unique id");
        }
        TranslogConfig translogConfig = config.getTranslogConfig();
        DefaultTranslogDeletionPolicy translogDeletionPolicy = new DefaultTranslogDeletionPolicy(config.getIndexSettings().getTranslogRetentionSize().getBytes(), config.getIndexSettings().getTranslogRetentionAge().getMillis(), config.getIndexSettings().getTranslogRetentionTotalFiles());
        long localCheckpoint = Long.parseLong((String)infos.getUserData().get("local_checkpoint"));
        translogDeletionPolicy.setLocalCheckpointOfSafeCommit(localCheckpoint);
        try (Translog translog = new Translog(translogConfig, translogUuid, translogDeletionPolicy, config.getGlobalCheckpointSupplier(), config.getPrimaryTermSupplier(), seqNo -> {});){
            TranslogStats translogStats = translog.stats();
            return translogStats;
        }
    }

    @Override
    public Engine.GetResult get(Engine.Get get, BiFunction<String, Engine.SearcherScope, Engine.Searcher> searcherFactory) throws EngineException {
        return this.getFromSearcher(get, searcherFactory, Engine.SearcherScope.EXTERNAL);
    }

    @Override
    protected ReferenceManager<EasysearchDirectoryReader> getReferenceManager(Engine.SearcherScope scope) {
        return this.readerManager;
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    public String getHistoryUUID() {
        return (String)this.lastCommittedSegmentInfos.userData.get("history_uuid");
    }

    @Override
    public long getWritingBytes() {
        return 0L;
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return 0L;
    }

    @Override
    public boolean isThrottled() {
        return false;
    }

    @Override
    public Engine.IndexResult index(Engine.Index index) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("indexing is not supported on a read-only engine");
    }

    @Override
    public Engine.DeleteResult delete(Engine.Delete delete) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("deletes are not supported on a read-only engine");
    }

    @Override
    public Engine.NoOpResult noOp(Engine.NoOp noOp) {
        assert (false) : "this should not be called";
        throw new UnsupportedOperationException("no-ops are not supported on a read-only engine");
    }

    @Override
    public boolean isTranslogSyncNeeded() {
        return false;
    }

    @Override
    public boolean ensureTranslogSynced(Stream<Translog.Location> locations) {
        return false;
    }

    @Override
    public void syncTranslog() {
    }

    @Override
    public Closeable acquireHistoryRetentionLock(Engine.HistorySource historySource) {
        return () -> {};
    }

    @Override
    public Translog.Snapshot newChangesSnapshot(String source, MapperService mapperService, long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        if (!this.engineConfig.getIndexSettings().isSoftDeleteEnabled()) {
            throw new IllegalStateException("accessing changes snapshot requires soft-deletes enabled");
        }
        return this.newEmptySnapshot();
    }

    @Override
    public Translog.Snapshot readHistoryOperations(String reason, Engine.HistorySource historySource, MapperService mapperService, long startingSeqNo) {
        return this.newEmptySnapshot();
    }

    @Override
    public int estimateNumberOfHistoryOperations(String reason, Engine.HistorySource historySource, MapperService mapperService, long startingSeqNo) {
        return 0;
    }

    @Override
    public boolean hasCompleteOperationHistory(String reason, Engine.HistorySource historySource, MapperService mapperService, long startingSeqNo) {
        return startingSeqNo > this.seqNoStats.getMaxSeqNo();
    }

    @Override
    public long getMinRetainedSeqNo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TranslogStats getTranslogStats() {
        return this.translogStats;
    }

    @Override
    public Translog.Location getTranslogLastWriteLocation() {
        return new Translog.Location(0L, 0L, 0);
    }

    @Override
    public long getPersistedLocalCheckpoint() {
        return this.seqNoStats.getLocalCheckpoint();
    }

    @Override
    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return new SeqNoStats(this.seqNoStats.getMaxSeqNo(), this.seqNoStats.getLocalCheckpoint(), globalCheckpoint);
    }

    @Override
    public long getLastSyncedGlobalCheckpoint() {
        return this.seqNoStats.getGlobalCheckpoint();
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return 0L;
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        return Arrays.asList(this.getSegmentInfo(this.lastCommittedSegmentInfos, verbose));
    }

    @Override
    public void refresh(String source) {
    }

    @Override
    public boolean maybeRefresh(String source) throws EngineException {
        return false;
    }

    @Override
    public void writeIndexingBuffer() throws EngineException {
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        return false;
    }

    @Override
    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) {
        throw new UnsupportedOperationException("syncedFlush is not supported on a read-only engine");
    }

    @Override
    public Engine.CommitId flush(boolean force, boolean waitIfOngoing) throws EngineException {
        return new Engine.CommitId(this.lastCommittedSegmentInfos.getId());
    }

    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments, String forceMergeUUID) {
    }

    @Override
    public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) {
        this.store.incRef();
        return new Engine.IndexCommitRef(this.indexCommit, this.store::decRef);
    }

    @Override
    public Engine.IndexCommitRef acquireSafeIndexCommit() {
        return this.acquireLastIndexCommit(false);
    }

    @Override
    public SafeCommitInfo getSafeCommitInfo() {
        return this.safeCommitInfo;
    }

    @Override
    public void activateThrottling() {
    }

    @Override
    public void deactivateThrottling() {
    }

    @Override
    public void trimUnreferencedTranslogFiles() {
    }

    @Override
    public boolean shouldRollTranslogGeneration() {
        return false;
    }

    @Override
    public void rollTranslogGeneration() {
    }

    @Override
    public int restoreLocalHistoryFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner) {
        return 0;
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) {
        return 0;
    }

    @Override
    public Engine recoverFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo) {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            try (Translog.Snapshot snapshot = this.newEmptySnapshot();){
                translogRecoveryRunner.run(this, snapshot);
            }
            catch (Exception e) {
                throw new EngineException(this.shardId, "failed to recover from empty translog snapshot", e, new Object[0]);
            }
        }
        return this;
    }

    @Override
    public void skipTranslogRecovery() {
    }

    @Override
    public void trimOperationsFromTranslog(long belowTerm, long aboveSeqNo) {
    }

    @Override
    public void maybePruneDeletes() {
    }

    @Override
    public void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
    }

    protected void processReader(EasysearchDirectoryReader reader) {
        this.refreshListener.accept(reader, null);
    }

    @Override
    public boolean refreshNeeded() {
        return false;
    }

    private Translog.Snapshot newEmptySnapshot() {
        return new Translog.Snapshot(){

            @Override
            public void close() {
            }

            @Override
            public int totalOperations() {
                return 0;
            }

            @Override
            public Translog.Operation next() {
                return null;
            }
        };
    }

    @Override
    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.seqNoStats.getMaxSeqNo();
    }

    @Override
    public void advanceMaxSeqNoOfUpdatesOrDeletes(long maxSeqNoOfUpdatesOnPrimary) {
        assert (maxSeqNoOfUpdatesOnPrimary <= this.getMaxSeqNoOfUpdatesOrDeletes()) : maxSeqNoOfUpdatesOnPrimary + ">" + this.getMaxSeqNoOfUpdatesOrDeletes();
    }

    protected static DirectoryReader openDirectory(Directory directory, boolean wrapSoftDeletes) throws IOException {
        assert (Transports.assertNotTransportThread("opening directory reader of a read-only engine"));
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        if (wrapSoftDeletes) {
            return new SoftDeletesDirectoryReaderWrapper(reader, "__soft_deletes");
        }
        return reader;
    }

    @Override
    public CompletionStats completionStats(String ... fieldNamePatterns) {
        return this.completionStatsCache.get(fieldNamePatterns);
    }
}

