/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.easysearch.index.fielddata.IndexFieldData;
import org.easysearch.index.mapper.ValueFetcher;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.lookup.SourceLookup;

public class DocValueFetcher
implements ValueFetcher {
    protected final DocValueFormat format;
    protected final IndexFieldData<?> ifd;
    protected Leaf leaf;

    public DocValueFetcher(DocValueFormat format, IndexFieldData<?> ifd) {
        this.format = format;
        this.ifd = ifd;
    }

    @Override
    public void setNextReader(LeafReaderContext context) {
        this.leaf = this.ifd.load(context).getLeafValueFetcher(this.format);
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) throws IOException {
        if (!this.leaf.advanceExact(lookup.docId())) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.leaf.docValueCount());
        int count = this.leaf.docValueCount();
        for (int i = 0; i < count; ++i) {
            result.add(this.leaf.nextValue());
        }
        return result;
    }

    public List<Object> fetchDocValues(int docId) throws IOException {
        if (!this.leaf.advanceExact(docId)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.leaf.docValueCount());
        int count = this.leaf.docValueCount();
        for (int i = 0; i < count; ++i) {
            result.add(this.leaf.nextValue());
        }
        return result;
    }

    public static interface Leaf {
        public boolean advanceExact(int var1) throws IOException;

        public int docValueCount() throws IOException;

        public Object nextValue() throws IOException;
    }
}

