/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.io.IOException;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.easysearch.EasysearchParseException;
import org.easysearch.Version;
import org.easysearch.common.Strings;
import org.easysearch.common.collect.Tuple;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.time.DateFormatter;
import org.easysearch.common.xcontent.LoggingDeprecationHandler;
import org.easysearch.common.xcontent.XContentHelper;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.XContentType;
import org.easysearch.index.IndexSettings;
import org.easysearch.index.mapper.BinaryFieldMapper;
import org.easysearch.index.mapper.BooleanFieldMapper;
import org.easysearch.index.mapper.ContentPath;
import org.easysearch.index.mapper.DateFieldMapper;
import org.easysearch.index.mapper.DocumentMapper;
import org.easysearch.index.mapper.DocumentMapperParser;
import org.easysearch.index.mapper.DynamicTemplate;
import org.easysearch.index.mapper.FieldAliasMapper;
import org.easysearch.index.mapper.FieldMapper;
import org.easysearch.index.mapper.IdFieldMapper;
import org.easysearch.index.mapper.KeywordFieldMapper;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperParsingException;
import org.easysearch.index.mapper.Mapping;
import org.easysearch.index.mapper.MetadataFieldMapper;
import org.easysearch.index.mapper.NumberFieldMapper;
import org.easysearch.index.mapper.ObjectMapper;
import org.easysearch.index.mapper.ParseContext;
import org.easysearch.index.mapper.ParsedDocument;
import org.easysearch.index.mapper.SourceToParse;
import org.easysearch.index.mapper.StrictDynamicMappingException;
import org.easysearch.index.mapper.TextFieldMapper;
import org.easysearch.index.mapper.TypeFieldMapper;

final class DocumentParser {
    private final IndexSettings indexSettings;
    private final DocumentMapperParser docMapperParser;
    private final DocumentMapper docMapper;

    DocumentParser(IndexSettings indexSettings, DocumentMapperParser docMapperParser, DocumentMapper docMapper) {
        this.indexSettings = indexSettings;
        this.docMapperParser = docMapperParser;
        this.docMapper = docMapper;
    }

    ParsedDocument parseDocument(SourceToParse source, MetadataFieldMapper[] metadataFieldsMappers) throws MapperParsingException {
        ParseContext.InternalParseContext context;
        this.validateType(source);
        Mapping mapping = this.docMapper.mapping();
        XContentType xContentType = source.getXContentType();
        Map<String, Object> source2 = null;
        try (XContentParser parser = XContentHelper.createParser(this.docMapperParser.getXContentRegistry(), LoggingDeprecationHandler.INSTANCE, source.source(), xContentType);){
            context = new ParseContext.InternalParseContext(this.indexSettings, this.docMapperParser, this.docMapper, source, parser);
            DocumentParser.validateStart(parser);
            DocumentParser.internalParseDocument(mapping, metadataFieldsMappers, context, parser);
            DocumentParser.validateEnd(parser);
            source2 = context.postSavedSource(source.source());
        }
        catch (Exception e) {
            throw DocumentParser.wrapInMapperParsingException(source, e);
        }
        String remainingPath = context.path().pathAsText("");
        if (!remainingPath.isEmpty()) {
            throw new IllegalStateException("found leftover path elements: " + remainingPath);
        }
        context.postParse();
        ParsedDocument parsedDocument = DocumentParser.parsedDocument(source, context, DocumentParser.createDynamicUpdate(mapping, this.docMapper, context.getDynamicMappers(), context.metaUpdated));
        parsedDocument.source2 = source2;
        return parsedDocument;
    }

    private static boolean containsDisabledObjectMapper(ObjectMapper objectMapper, String[] subfields) {
        Mapper mapper;
        for (int i = 0; i < subfields.length - 1 && (mapper = objectMapper.getMapper(subfields[i])) instanceof ObjectMapper; ++i) {
            objectMapper = (ObjectMapper)mapper;
            if (objectMapper.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private static void internalParseDocument(Mapping mapping, MetadataFieldMapper[] metadataFieldsMappers, ParseContext.InternalParseContext context, XContentParser parser) throws IOException {
        boolean emptyDoc = DocumentParser.isEmptyDoc(mapping, parser);
        for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
            metadataMapper.preParse(context);
        }
        if (!mapping.root.isEnabled()) {
            parser.skipChildren();
        } else if (!emptyDoc) {
            DocumentParser.parseObjectOrNested(context, mapping.root);
        }
        for (MetadataFieldMapper metadataMapper : metadataFieldsMappers) {
            metadataMapper.postParse(context);
        }
    }

    private void validateType(SourceToParse source) {
        if (this.docMapper.type().equals("_default_")) {
            throw new IllegalArgumentException("It is forbidden to index into the default mapping [_default_]");
        }
        if (!Objects.equals(source.type(), this.docMapper.type()) && !"_doc".equals(source.type())) {
            throw new MapperParsingException("Type mismatch, provide type [" + source.type() + "] but mapper is of type [" + this.docMapper.type() + "]");
        }
    }

    private static void validateStart(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new MapperParsingException("Malformed content, must start with an object");
        }
    }

    private static void validateEnd(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != null) {
            throw new IllegalArgumentException("Malformed content, found extra data after parsing: " + token);
        }
    }

    private static boolean isEmptyDoc(Mapping mapping, XContentParser parser) throws IOException {
        if (mapping.root.isEnabled()) {
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.END_OBJECT) {
                return true;
            }
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new MapperParsingException("Malformed content, after first object, either the type field or the actual properties should exist");
            }
        }
        return false;
    }

    private static ParsedDocument parsedDocument(SourceToParse source, ParseContext.InternalParseContext context, Mapping update) {
        return new ParsedDocument(context.version(), context.seqID(), context.sourceToParse().id(), context.sourceToParse().type(), source.routing(), context.docs(), context.sourceToParse().source(), context.sourceToParse().getXContentType(), update);
    }

    private static MapperParsingException wrapInMapperParsingException(SourceToParse source, Exception e) {
        if (e instanceof MapperParsingException) {
            return (MapperParsingException)e;
        }
        if (source.source() != null && source.source().length() == 0) {
            return new MapperParsingException("failed to parse, document is empty");
        }
        return new MapperParsingException("failed to parse", e);
    }

    private static String[] splitAndValidatePath(String fullFieldPath) {
        if (fullFieldPath.contains(".")) {
            String[] parts;
            for (String part : parts = fullFieldPath.split("\\.")) {
                if (Strings.hasText(part)) continue;
                if (!Strings.isEmpty(part)) {
                    throw new IllegalArgumentException("object field cannot contain only whitespace: ['" + fullFieldPath + "']");
                }
                throw new IllegalArgumentException("object field starting or ending with a [.] makes object resolution ambiguous: [" + fullFieldPath + "]");
            }
            return parts;
        }
        if (Strings.isEmpty(fullFieldPath)) {
            throw new IllegalArgumentException("field name cannot be an empty string");
        }
        return new String[]{fullFieldPath};
    }

    static Mapping createDynamicUpdate(Mapping mapping, DocumentMapper docMapper, List<Mapper> dynamicMappers, boolean metaUpdated) {
        if (dynamicMappers.isEmpty()) {
            return metaUpdated ? mapping : null;
        }
        Collections.sort(dynamicMappers, (o1, o2) -> o1.name().compareTo(o2.name()));
        Iterator<Mapper> dynamicMapperItr = dynamicMappers.iterator();
        ArrayList<ObjectMapper> parentMappers = new ArrayList<ObjectMapper>();
        Mapper firstUpdate = dynamicMapperItr.next();
        parentMappers.add(DocumentParser.createUpdate(mapping.root(), DocumentParser.splitAndValidatePath(firstUpdate.name()), 0, firstUpdate));
        Mapper previousMapper = null;
        while (dynamicMapperItr.hasNext()) {
            Mapper newMapper = dynamicMapperItr.next();
            if (previousMapper != null && newMapper.name().equals(previousMapper.name())) {
                newMapper.merge(previousMapper);
                continue;
            }
            previousMapper = newMapper;
            String[] nameParts = DocumentParser.splitAndValidatePath(newMapper.name());
            int i = DocumentParser.removeUncommonMappers(parentMappers, nameParts);
            if ((i = DocumentParser.expandCommonMappers(parentMappers, nameParts, i)) < nameParts.length - 1) {
                newMapper = DocumentParser.createExistingMapperUpdate(parentMappers, nameParts, i, docMapper, newMapper);
            }
            if (newMapper instanceof ObjectMapper) {
                parentMappers.add((ObjectMapper)newMapper);
                continue;
            }
            DocumentParser.addToLastMapper(parentMappers, newMapper, true);
        }
        DocumentParser.popMappers(parentMappers, 1, true);
        assert (parentMappers.size() == 1);
        return mapping.mappingUpdate((Mapper)parentMappers.get(0));
    }

    private static void popMappers(List<ObjectMapper> parentMappers, int keepBefore, boolean merge) {
        assert (keepBefore >= 1);
        for (int i = parentMappers.size() - 1; i >= keepBefore; --i) {
            DocumentParser.addToLastMapper(parentMappers, parentMappers.remove(i), merge);
        }
    }

    private static void addToLastMapper(List<ObjectMapper> parentMappers, Mapper mapper, boolean merge) {
        assert (parentMappers.size() >= 1);
        int lastIndex = parentMappers.size() - 1;
        ObjectMapper withNewMapper = parentMappers.get(lastIndex).mappingUpdate(mapper);
        if (merge) {
            withNewMapper = parentMappers.get(lastIndex).merge(withNewMapper);
        }
        parentMappers.set(lastIndex, withNewMapper);
    }

    private static int removeUncommonMappers(List<ObjectMapper> parentMappers, String[] nameParts) {
        int keepBefore;
        for (keepBefore = 1; keepBefore < parentMappers.size() && parentMappers.get(keepBefore).simpleName().equals(nameParts[keepBefore - 1]); ++keepBefore) {
        }
        DocumentParser.popMappers(parentMappers, keepBefore, true);
        return keepBefore - 1;
    }

    private static int expandCommonMappers(List<ObjectMapper> parentMappers, String[] nameParts, int i) {
        ObjectMapper last = parentMappers.get(parentMappers.size() - 1);
        while (i < nameParts.length - 1 && last.getMapper(nameParts[i]) != null) {
            Mapper newLast = last.getMapper(nameParts[i]);
            assert (newLast instanceof ObjectMapper);
            last = (ObjectMapper)newLast;
            parentMappers.add(last);
            ++i;
        }
        return i;
    }

    private static ObjectMapper createExistingMapperUpdate(List<ObjectMapper> parentMappers, String[] nameParts, int i, DocumentMapper docMapper, Mapper newMapper) {
        Object updateParentName = nameParts[i];
        ObjectMapper lastParent = parentMappers.get(parentMappers.size() - 1);
        if (parentMappers.size() > 1) {
            updateParentName = lastParent.name() + "." + nameParts[i];
        }
        ObjectMapper updateParent = docMapper.objectMappers().get(updateParentName);
        assert (updateParent != null) : (String)updateParentName + " doesn't exist";
        return DocumentParser.createUpdate(updateParent, nameParts, i + 1, newMapper);
    }

    private static ObjectMapper createUpdate(ObjectMapper parent, String[] nameParts, int i, Mapper mapper) {
        ArrayList<ObjectMapper> parentMappers = new ArrayList<ObjectMapper>();
        ObjectMapper previousIntermediate = parent;
        while (i < nameParts.length - 1) {
            Mapper intermediate = previousIntermediate.getMapper(nameParts[i]);
            assert (intermediate != null) : "Field " + previousIntermediate.name() + " does not have a subfield " + nameParts[i];
            assert (intermediate instanceof ObjectMapper);
            parentMappers.add((ObjectMapper)intermediate);
            previousIntermediate = (ObjectMapper)intermediate;
            ++i;
        }
        if (!parentMappers.isEmpty()) {
            DocumentParser.addToLastMapper(parentMappers, mapper, false);
            DocumentParser.popMappers(parentMappers, 1, false);
            mapper = (Mapper)parentMappers.get(0);
        }
        return parent.mappingUpdate(mapper);
    }

    static void parseObjectOrNested(ParseContext context, ObjectMapper mapper) throws IOException {
        if (!mapper.isEnabled()) {
            context.parser().skipChildren();
            return;
        }
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return;
        }
        String currentFieldName = parser.currentName();
        if (token.isValue()) {
            throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but found a concrete value");
        }
        ObjectMapper.Nested nested = mapper.nested();
        if (nested.isNested()) {
            context = DocumentParser.nestedContext(context, mapper);
        }
        if (token == XContentParser.Token.END_OBJECT) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        DocumentParser.innerParseObject(context, mapper, parser, currentFieldName, token);
        if (nested.isNested()) {
            DocumentParser.nested(context, nested);
        }
    }

    private static void innerParseObject(ParseContext context, ObjectMapper mapper, XContentParser parser, String currentFieldName, XContentParser.Token token) throws IOException {
        assert (token == XContentParser.Token.FIELD_NAME || token == XContentParser.Token.END_OBJECT);
        String[] paths = null;
        while (token != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                paths = DocumentParser.splitAndValidatePath(currentFieldName);
                if (DocumentParser.containsDisabledObjectMapper(mapper, paths)) {
                    parser.nextToken();
                    parser.skipChildren();
                }
            } else if (token == XContentParser.Token.START_OBJECT) {
                DocumentParser.parseObject(context, mapper, currentFieldName, paths);
            } else if (token == XContentParser.Token.START_ARRAY) {
                DocumentParser.parseArray(context, mapper, currentFieldName, paths);
            } else if (token == XContentParser.Token.VALUE_NULL) {
                DocumentParser.parseNullValue(context, mapper, currentFieldName, paths);
            } else {
                if (token == null) {
                    throw new MapperParsingException("object mapping for [" + mapper.name() + "] tried to parse field [" + currentFieldName + "] as object, but got EOF, has a concrete value been provided to it?");
                }
                if (token.isValue()) {
                    DocumentParser.parseValue(context, mapper, currentFieldName, token, paths);
                }
            }
            token = parser.nextToken();
        }
    }

    private static void nested(ParseContext context, ObjectMapper.Nested nested) {
        ParseContext.Document nestedDoc = context.doc();
        ParseContext.Document parentDoc = nestedDoc.getParent();
        if (nested.isIncludeInParent()) {
            DocumentParser.addFields(nestedDoc, parentDoc);
        }
        if (nested.isIncludeInRoot()) {
            ParseContext.Document rootDoc = context.rootDoc();
            if (!nested.isIncludeInParent() || parentDoc != rootDoc) {
                DocumentParser.addFields(nestedDoc, rootDoc);
            }
        }
    }

    private static void addFields(ParseContext.Document nestedDoc, ParseContext.Document rootDoc) {
        for (IndexableField field : nestedDoc.getFields()) {
            if (field.name().equals("_type")) continue;
            rootDoc.add(field);
        }
    }

    private static ParseContext nestedContext(ParseContext context, ObjectMapper mapper) {
        ParseContext.Document nestedDoc = (context = context.createNestedContext(mapper.fullPath())).doc();
        ParseContext.Document parentDoc = nestedDoc.getParent();
        IndexableField idField = parentDoc.getField("_id");
        if (idField == null) {
            throw new IllegalStateException("The root document of a nested document should have an _id field");
        }
        nestedDoc.add((IndexableField)new Field("_id", idField.binaryValue(), (IndexableFieldType)IdFieldMapper.Defaults.NESTED_FIELD_TYPE));
        nestedDoc.add((IndexableField)new Field("_type", (CharSequence)mapper.nestedTypePathAsString(), (IndexableFieldType)TypeFieldMapper.Defaults.NESTED_FIELD_TYPE));
        return context;
    }

    private static void parseObjectOrField(ParseContext context, Mapper mapper) throws IOException {
        if (mapper instanceof ObjectMapper) {
            DocumentParser.parseObjectOrNested(context, (ObjectMapper)mapper);
        } else if (mapper instanceof FieldMapper) {
            FieldMapper fieldMapper = (FieldMapper)mapper;
            fieldMapper.parse(context);
            DocumentParser.parseCopyFields(context, fieldMapper.copyTo().copyToFields());
        } else {
            if (mapper instanceof FieldAliasMapper) {
                throw new IllegalArgumentException("Cannot write to a field alias [" + mapper.name() + "].");
            }
            throw new IllegalStateException("The provided mapper [" + mapper.name() + "] has an unrecognized type [" + mapper.getClass().getSimpleName() + "].");
        }
    }

    private static void parseObject(ParseContext context, ObjectMapper mapper, String currentFieldName, String[] paths) throws IOException {
        assert (currentFieldName != null);
        Mapper objectMapper = DocumentParser.getMapper(context, mapper, currentFieldName, paths);
        if (objectMapper != null) {
            context.path().add(currentFieldName);
            DocumentParser.parseObjectOrField(context, objectMapper);
            context.path().remove();
        } else {
            currentFieldName = paths[paths.length - 1];
            Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, mapper);
            ObjectMapper parentMapper = parentMapperTuple.v2();
            ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
            if (dynamic == ObjectMapper.Dynamic.STRICT) {
                throw new StrictDynamicMappingException(mapper.fullPath(), currentFieldName);
            }
            if (dynamic == ObjectMapper.Dynamic.TRUE) {
                Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.OBJECT);
                if (builder == null) {
                    builder = new ObjectMapper.Builder(currentFieldName).enabled(true);
                }
                Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings().getSettings(), context.path());
                objectMapper = builder.build(builderContext);
                context.addDynamicMapper(objectMapper);
                context.path().add(currentFieldName);
                DocumentParser.parseObjectOrField(context, objectMapper);
                context.path().remove();
            } else {
                context.parser().skipChildren();
            }
            for (int i = 0; i < parentMapperTuple.v1(); ++i) {
                context.path().remove();
            }
        }
    }

    private static void parseArray(ParseContext context, ObjectMapper parentMapper, String lastFieldName, String[] paths) throws IOException {
        String arrayFieldName = lastFieldName;
        Mapper mapper = DocumentParser.getMapper(context, parentMapper, lastFieldName, paths);
        if (mapper != null) {
            if (DocumentParser.parsesArrayValue(mapper)) {
                DocumentParser.parseObjectOrField(context, mapper);
            } else {
                DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
            }
        } else {
            lastFieldName = arrayFieldName = paths[paths.length - 1];
            Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, parentMapper);
            ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper = parentMapperTuple.v2(), context);
            if (dynamic == ObjectMapper.Dynamic.STRICT) {
                throw new StrictDynamicMappingException(parentMapper.fullPath(), arrayFieldName);
            }
            if (dynamic == ObjectMapper.Dynamic.TRUE) {
                Mapper.Builder builder = context.root().findTemplateBuilder(context, arrayFieldName, DynamicTemplate.XContentFieldType.OBJECT);
                if (builder == null) {
                    DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
                } else {
                    Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings().getSettings(), context.path());
                    mapper = builder.build(builderContext);
                    assert (mapper != null);
                    if (DocumentParser.parsesArrayValue(mapper)) {
                        context.addDynamicMapper(mapper);
                        context.path().add(arrayFieldName);
                        DocumentParser.parseObjectOrField(context, mapper);
                        context.path().remove();
                    } else {
                        DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
                    }
                }
            } else {
                DocumentParser.parseNonDynamicArray(context, parentMapper, lastFieldName, arrayFieldName);
            }
            for (int i = 0; i < parentMapperTuple.v1(); ++i) {
                context.path().remove();
            }
        }
    }

    private static boolean parsesArrayValue(Mapper mapper) {
        return mapper instanceof FieldMapper && ((FieldMapper)mapper).parsesArrayValue();
    }

    private static void parseNonDynamicArray(ParseContext context, ObjectMapper mapper, String lastFieldName, String arrayFieldName) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        String[] paths = DocumentParser.splitAndValidatePath(lastFieldName);
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.START_OBJECT) {
                context.docMapper().addSkipPath(context.path().pathAsText(lastFieldName), context);
                DocumentParser.parseObject(context, mapper, lastFieldName, paths);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                DocumentParser.parseArray(context, mapper, lastFieldName, paths);
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                DocumentParser.parseNullValue(context, mapper, lastFieldName, paths);
                continue;
            }
            if (token == null) {
                throw new MapperParsingException("object mapping for [" + mapper.name() + "] with array for [" + arrayFieldName + "] tried to parse as array, but got EOF, is there a mismatch in types for the same field?");
            }
            assert (token.isValue());
            DocumentParser.parseValue(context, mapper, lastFieldName, token, paths);
        }
    }

    private static void parseValue(ParseContext context, ObjectMapper parentMapper, String currentFieldName, XContentParser.Token token, String[] paths) throws IOException {
        if (currentFieldName == null) {
            throw new MapperParsingException("object mapping [" + parentMapper.name() + "] trying to serialize a value with no field associated with it, current value [" + context.parser().textOrNull() + "]");
        }
        Mapper mapper = DocumentParser.getMapper(context, parentMapper, currentFieldName, paths);
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else {
            currentFieldName = paths[paths.length - 1];
            Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, parentMapper);
            parentMapper = parentMapperTuple.v2();
            DocumentParser.parseDynamicValue(context, parentMapper, currentFieldName, token);
            for (int i = 0; i < parentMapperTuple.v1(); ++i) {
                context.path().remove();
            }
        }
    }

    private static void parseNullValue(ParseContext context, ObjectMapper parentMapper, String lastFieldName, String[] paths) throws IOException {
        Mapper mapper = DocumentParser.getMapper(context, parentMapper, lastFieldName, paths);
        if (mapper != null) {
            DocumentParser.parseObjectOrField(context, mapper);
        } else if (parentMapper.dynamic() == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), lastFieldName);
        }
    }

    private static Mapper.Builder<?> newLongBuilder(String name, Settings settings) {
        return new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.LONG, settings);
    }

    private static Mapper.Builder<?> newFloatBuilder(String name, Settings settings) {
        return new NumberFieldMapper.Builder(name, NumberFieldMapper.NumberType.FLOAT, settings);
    }

    private static Mapper.Builder<?> createBuilderFromDynamicValue(ParseContext context, XContentParser.Token token, String currentFieldName) throws IOException {
        if (token == XContentParser.Token.VALUE_STRING) {
            Object builder;
            String text = context.parser().text();
            boolean parseableAsLong = false;
            try {
                Long.parseLong(text);
                parseableAsLong = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            boolean parseableAsDouble = false;
            try {
                Double.parseDouble(text);
                parseableAsDouble = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (parseableAsLong && context.root().numericDetection()) {
                Mapper.Builder<?> builder2 = context.root().findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.LONG);
                if (builder2 == null) {
                    builder2 = DocumentParser.newLongBuilder(currentFieldName, context.indexSettings().getSettings());
                }
                return builder2;
            }
            if (parseableAsDouble && context.root().numericDetection()) {
                Mapper.Builder<?> builder3 = context.root().findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.DOUBLE);
                if (builder3 == null) {
                    builder3 = DocumentParser.newFloatBuilder(currentFieldName, context.indexSettings().getSettings());
                }
                return builder3;
            }
            if (!parseableAsLong && !parseableAsDouble && context.root().dateDetection()) {
                builder = context.root().dynamicDateTimeFormatters();
                int n = ((DateFormatter[])builder).length;
                for (int i = 0; i < n; ++i) {
                    DateFormatter dateTimeFormatter = builder[i];
                    try {
                        dateTimeFormatter.parse(text);
                    }
                    catch (IllegalArgumentException | DateTimeParseException | EasysearchParseException e) {
                        continue;
                    }
                    Mapper.Builder builder4 = context.root().findTemplateBuilder(context, currentFieldName, dateTimeFormatter);
                    if (builder4 == null) {
                        boolean ignoreMalformed = FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings().getSettings());
                        builder4 = new DateFieldMapper.Builder(currentFieldName, DateFieldMapper.Resolution.MILLISECONDS, dateTimeFormatter, ignoreMalformed, Version.indexCreated(context.indexSettings().getSettings()));
                    }
                    return builder4;
                }
            }
            if ((builder = context.root().findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.STRING)) == null) {
                builder = new TextFieldMapper.Builder(currentFieldName, context.mapperService().getIndexAnalyzers()).addMultiField(new KeywordFieldMapper.Builder("keyword").ignoreAbove(256));
            }
            return builder;
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = context.parser().numberType();
            if (numberType == XContentParser.NumberType.INT || numberType == XContentParser.NumberType.LONG || numberType == XContentParser.NumberType.BIG_INTEGER) {
                Mapper.Builder<?> builder = context.root().findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.LONG);
                if (builder == null) {
                    builder = DocumentParser.newLongBuilder(currentFieldName, context.indexSettings().getSettings());
                }
                return builder;
            }
            if (numberType == XContentParser.NumberType.FLOAT || numberType == XContentParser.NumberType.DOUBLE || numberType == XContentParser.NumberType.BIG_DECIMAL) {
                Mapper.Builder<?> builder = context.root().findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.DOUBLE);
                if (builder == null) {
                    builder = DocumentParser.newFloatBuilder(currentFieldName, context.indexSettings().getSettings());
                }
                return builder;
            }
        } else {
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.BOOLEAN);
                if (builder == null) {
                    builder = new BooleanFieldMapper.Builder(currentFieldName);
                }
                return builder;
            }
            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.BINARY);
                if (builder == null) {
                    builder = new BinaryFieldMapper.Builder(currentFieldName);
                }
                return builder;
            }
            Mapper.Builder builder = context.root().findTemplateBuilder(context, currentFieldName, DynamicTemplate.XContentFieldType.STRING);
            if (builder != null) {
                return builder;
            }
        }
        throw new IllegalStateException("Can't handle serializing a dynamic type with content token [" + token + "] and field name [" + currentFieldName + "]");
    }

    private static void parseDynamicValue(ParseContext context, ObjectMapper parentMapper, String currentFieldName, XContentParser.Token token) throws IOException {
        ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parentMapper, context);
        if (dynamic == ObjectMapper.Dynamic.STRICT) {
            throw new StrictDynamicMappingException(parentMapper.fullPath(), currentFieldName);
        }
        if (dynamic == ObjectMapper.Dynamic.FALSE) {
            return;
        }
        Mapper.BuilderContext builderContext = new Mapper.BuilderContext(context.indexSettings().getSettings(), context.path());
        Mapper.Builder<?> builder = DocumentParser.createBuilderFromDynamicValue(context, token, currentFieldName);
        Mapper mapper = builder.build(builderContext);
        context.addDynamicMapper(mapper);
        DocumentParser.parseObjectOrField(context, mapper);
    }

    private static void parseCopyFields(ParseContext context, List<String> copyToFields) throws IOException {
        if (!context.isWithinCopyTo() && !copyToFields.isEmpty()) {
            context = context.createCopyToContext();
            for (String field : copyToFields) {
                ParseContext.Document targetDoc = null;
                for (ParseContext.Document doc = context.doc(); doc != null; doc = doc.getParent()) {
                    if (!field.startsWith(doc.getPrefix())) continue;
                    targetDoc = doc;
                    break;
                }
                assert (targetDoc != null);
                ParseContext copyToContext = targetDoc == context.doc() ? context : context.switchDoc(targetDoc);
                DocumentParser.parseCopy(field, copyToContext);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseCopy(String field, ParseContext context) throws IOException {
        Mapper mapper = context.docMapper().mappers().getMapper(field);
        if (mapper != null) {
            if (mapper instanceof FieldMapper) {
                ((FieldMapper)mapper).parse(context);
                return;
            }
            if (!(mapper instanceof FieldAliasMapper)) throw new IllegalStateException("The provided mapper [" + mapper.name() + "] has an unrecognized type [" + mapper.getClass().getSimpleName() + "].");
            throw new IllegalArgumentException("Cannot copy to a field alias [" + mapper.name() + "].");
        }
        context = context.overridePath(new ContentPath(0));
        String[] paths = DocumentParser.splitAndValidatePath(field);
        String fieldName = paths[paths.length - 1];
        Tuple<Integer, ObjectMapper> parentMapperTuple = DocumentParser.getDynamicParentMapper(context, paths, null);
        ObjectMapper objectMapper = parentMapperTuple.v2();
        DocumentParser.parseDynamicValue(context, objectMapper, fieldName, context.parser().currentToken());
        int i = 0;
        while (i < parentMapperTuple.v1()) {
            context.path().remove();
            ++i;
        }
    }

    private static Tuple<Integer, ObjectMapper> getDynamicParentMapper(ParseContext context, String[] paths, ObjectMapper currentParent) {
        ObjectMapper mapper = currentParent == null ? context.root() : currentParent;
        int pathsAdded = 0;
        ObjectMapper parent = mapper;
        for (int i = 0; i < paths.length - 1; ++i) {
            String currentPath = context.path().pathAsText(paths[i]);
            Mapper existingFieldMapper = context.docMapper().mappers().getMapper(currentPath);
            if (existingFieldMapper != null) {
                throw new MapperParsingException("Could not dynamically add mapping for field [{}]. Existing mapping for [{}] must be of type object but found [{}].", null, String.join((CharSequence)".", paths), currentPath, existingFieldMapper.typeName());
            }
            mapper = context.docMapper().objectMappers().get(currentPath);
            if (mapper == null) {
                ObjectMapper.Dynamic dynamic = DocumentParser.dynamicOrDefault(parent, context);
                switch (dynamic) {
                    case STRICT: {
                        throw new StrictDynamicMappingException(parent.fullPath(), paths[i]);
                    }
                    case TRUE: {
                        Mapper.BuilderContext builderContext;
                        Mapper.Builder builder = context.root().findTemplateBuilder(context, paths[i], DynamicTemplate.XContentFieldType.OBJECT);
                        if (builder == null) {
                            builder = new ObjectMapper.Builder(paths[i]).enabled(true);
                        }
                        if ((mapper = (ObjectMapper)builder.build(builderContext = new Mapper.BuilderContext(context.indexSettings().getSettings(), context.path()))).nested() != ObjectMapper.Nested.NO) {
                            throw new MapperParsingException("It is forbidden to create dynamic nested objects ([" + context.path().pathAsText(paths[i]) + "]) through `copy_to` or dots in field names");
                        }
                        context.addDynamicMapper(mapper);
                        break;
                    }
                    case FALSE: {
                        return new Tuple<Integer, ObjectMapper>(pathsAdded, parent);
                    }
                }
            }
            context.path().add(paths[i]);
            ++pathsAdded;
            parent = mapper;
        }
        return new Tuple<Integer, ObjectMapper>(pathsAdded, mapper);
    }

    private static ObjectMapper.Dynamic dynamicOrDefault(ObjectMapper parentMapper, ParseContext context) {
        int lastDotNdx;
        ObjectMapper.Dynamic dynamic = parentMapper.dynamic();
        while (dynamic == null && (lastDotNdx = parentMapper.name().lastIndexOf(46)) != -1) {
            String parentName = parentMapper.name().substring(0, lastDotNdx);
            parentMapper = context.docMapper().objectMappers().get(parentName);
            if (parentMapper == null) {
                return ObjectMapper.Dynamic.TRUE;
            }
            dynamic = parentMapper.dynamic();
        }
        if (dynamic == null) {
            return context.root().dynamic() == null ? ObjectMapper.Dynamic.TRUE : context.root().dynamic();
        }
        return dynamic;
    }

    private static Mapper getMapper(ParseContext context, ObjectMapper objectMapper, String fieldName, String[] subfields) {
        String fieldPath = context.path().pathAsText(fieldName);
        Mapper mapper = context.docMapper().mapping().getMetadataMapper(fieldPath);
        if (mapper != null) {
            return mapper;
        }
        for (int i = 0; i < subfields.length - 1; ++i) {
            mapper = objectMapper.getMapper(subfields[i]);
            if (mapper == null || !(mapper instanceof ObjectMapper)) {
                return null;
            }
            objectMapper = (ObjectMapper)mapper;
            if (!objectMapper.nested().isNested()) continue;
            throw new MapperParsingException("Cannot add a value for field [" + fieldName + "] since one of the intermediate objects is mapped as a nested object: [" + mapper.name() + "]");
        }
        return objectMapper.getMapper(subfields[subfields.length - 1]);
    }
}

