/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.easysearch.Version;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.time.DateFormatter;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.index.analysis.IndexAnalyzers;
import org.easysearch.index.mapper.ContentPath;
import org.easysearch.index.mapper.MapperParsingException;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.MappingLookup;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.index.similarity.SimilarityProvider;
import org.easysearch.script.ScriptService;

public abstract class Mapper
implements ToXContentFragment,
Iterable<Mapper> {
    private final String simpleName;

    public Mapper(String simpleName) {
        Objects.requireNonNull(simpleName);
        this.simpleName = simpleName;
    }

    public final String simpleName() {
        return this.simpleName;
    }

    public abstract String name();

    public abstract String typeName();

    public abstract Mapper merge(Mapper var1);

    public abstract void validate(MappingLookup var1);

    private static final boolean startsWith(String name1, String name2) {
        return name1.startsWith(name2) && name1.length() > name2.length() && name1.charAt(name2.length()) == '.';
    }

    public static final boolean startsWithAny(String name1, Collection<String> collection) {
        for (String s2 : collection) {
            if (!Mapper.startsWith(name1, s2)) continue;
            return true;
        }
        return false;
    }

    public static interface TypeParser {
        public Builder<?> parse(String var1, Map<String, Object> var2, ParserContext var3) throws MapperParsingException;

        public static class ParserContext {
            private final Function<String, SimilarityProvider> similarityLookupService;
            private final MapperService mapperService;
            private final Function<String, TypeParser> typeParsers;
            private final Version indexVersionCreated;
            private final Supplier<QueryShardContext> queryShardContextSupplier;
            private final DateFormatter dateFormatter;
            private final ScriptService scriptService;

            public ParserContext(Function<String, SimilarityProvider> similarityLookupService, MapperService mapperService, Function<String, TypeParser> typeParsers, Version indexVersionCreated, Supplier<QueryShardContext> queryShardContextSupplier, DateFormatter dateFormatter, ScriptService scriptService) {
                this.similarityLookupService = similarityLookupService;
                this.mapperService = mapperService;
                this.typeParsers = typeParsers;
                this.indexVersionCreated = indexVersionCreated;
                this.queryShardContextSupplier = queryShardContextSupplier;
                this.dateFormatter = dateFormatter;
                this.scriptService = scriptService;
            }

            public IndexAnalyzers getIndexAnalyzers() {
                return this.mapperService.getIndexAnalyzers();
            }

            public Settings getSettings() {
                return this.mapperService.getIndexSettings().getSettings();
            }

            public SimilarityProvider getSimilarity(String name) {
                return this.similarityLookupService.apply(name);
            }

            public MapperService mapperService() {
                return this.mapperService;
            }

            public TypeParser typeParser(String type) {
                return this.typeParsers.apply(type);
            }

            public Version indexVersionCreated() {
                return this.indexVersionCreated;
            }

            public Supplier<QueryShardContext> queryShardContextSupplier() {
                return this.queryShardContextSupplier;
            }

            public DateFormatter getDateFormatter() {
                return this.dateFormatter;
            }

            public boolean isWithinMultiField() {
                return false;
            }

            protected Function<String, TypeParser> typeParsers() {
                return this.typeParsers;
            }

            protected Function<String, SimilarityProvider> similarityLookupService() {
                return this.similarityLookupService;
            }

            public ScriptService scriptService() {
                return this.scriptService;
            }

            public ParserContext createMultiFieldContext(ParserContext in) {
                return new MultiFieldParserContext(in);
            }

            static class MultiFieldParserContext
            extends ParserContext {
                MultiFieldParserContext(ParserContext in) {
                    super(in.similarityLookupService(), in.mapperService(), in.typeParsers(), in.indexVersionCreated(), in.queryShardContextSupplier(), in.getDateFormatter(), in.scriptService());
                }

                @Override
                public boolean isWithinMultiField() {
                    return true;
                }
            }
        }
    }

    public static abstract class Builder<T extends Builder> {
        public String name;
        protected T builder;

        protected Builder(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract Mapper build(BuilderContext var1);
    }

    public static class BuilderContext {
        private final Settings indexSettings;
        private final ContentPath contentPath;

        public BuilderContext(Settings indexSettings, ContentPath contentPath) {
            Objects.requireNonNull(indexSettings, "indexSettings is required");
            this.contentPath = contentPath;
            this.indexSettings = indexSettings;
        }

        public ContentPath path() {
            return this.contentPath;
        }

        public Settings indexSettings() {
            return this.indexSettings;
        }

        public Version indexCreatedVersion() {
            return Version.indexCreated(this.indexSettings);
        }
    }
}

