/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MetadataFieldMapper;
import org.easysearch.index.mapper.ParametrizedFieldMapper;
import org.easysearch.index.mapper.RankFeatureFieldMapper;
import org.easysearch.index.mapper.RankFeatureMetaFieldMapper;
import org.easysearch.index.mapper.RankFeaturesFieldMapper;
import org.easysearch.index.mapper.ScaledFloatFieldMapper;
import org.easysearch.index.mapper.SearchAsYouTypeFieldMapper;
import org.easysearch.index.mapper.TokenCountFieldMapper;
import org.easysearch.index.query.RankFeatureQueryBuilder;
import org.easysearch.plugins.MapperPlugin;
import org.easysearch.plugins.Plugin;
import org.easysearch.plugins.SearchPlugin;

public class MapperExtrasPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    @Override
    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, ParametrizedFieldMapper.TypeParser> mappers = new LinkedHashMap<String, ParametrizedFieldMapper.TypeParser>();
        mappers.put("scaled_float", ScaledFloatFieldMapper.PARSER);
        mappers.put("token_count", TokenCountFieldMapper.PARSER);
        mappers.put("rank_feature", RankFeatureFieldMapper.PARSER);
        mappers.put("rank_features", RankFeaturesFieldMapper.PARSER);
        mappers.put("search_as_you_type", SearchAsYouTypeFieldMapper.PARSER);
        return Collections.unmodifiableMap(mappers);
    }

    @Override
    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Collections.singletonMap("_feature", RankFeatureMetaFieldMapper.PARSER);
    }

    @Override
    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec<RankFeatureQueryBuilder>("rank_feature", RankFeatureQueryBuilder::new, p -> RankFeatureQueryBuilder.PARSER.parse(p, null)));
    }
}

