/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.mapper;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.easysearch.common.Explicit;
import org.easysearch.common.settings.Setting;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.common.xcontent.support.XContentMapValues;
import org.easysearch.index.fielddata.FieldData;
import org.easysearch.index.fielddata.IndexFieldData;
import org.easysearch.index.fielddata.IndexNumericFieldData;
import org.easysearch.index.fielddata.LeafNumericFieldData;
import org.easysearch.index.fielddata.NumericDoubleValues;
import org.easysearch.index.fielddata.ScriptDocValues;
import org.easysearch.index.fielddata.SortedBinaryDocValues;
import org.easysearch.index.fielddata.SortedNumericDoubleValues;
import org.easysearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.easysearch.index.mapper.DocValueFetcher;
import org.easysearch.index.mapper.FieldMapper;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.NumberFieldMapper;
import org.easysearch.index.mapper.ParametrizedFieldMapper;
import org.easysearch.index.mapper.ParseContext;
import org.easysearch.index.mapper.SimpleMappedFieldType;
import org.easysearch.index.mapper.SourceValueFetcher;
import org.easysearch.index.mapper.TextSearchInfo;
import org.easysearch.index.mapper.ValueFetcher;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.DocValueFormat;
import org.easysearch.search.aggregations.support.ValuesSourceType;
import org.easysearch.search.lookup.SearchLookup;

public class ScaledFloatFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "scaled_float";
    private static final Setting<Boolean> COERCE_SETTING = NumberFieldMapper.COERCE_SETTING;
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getSettings()));
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> coerce;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Double nullValue;
    private final double scalingFactor;
    private final boolean ignoreMalformedByDefault;
    private final boolean coerceByDefault;

    private static ScaledFloatFieldMapper toType(FieldMapper in) {
        return (ScaledFloatFieldMapper)in;
    }

    private ScaledFloatFieldMapper(String simpleName, ScaledFloatFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.stored = builder.stored.getValue();
        this.scalingFactor = builder.scalingFactor.getValue();
        this.nullValue = builder.nullValue.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.coerce = builder.coerce.getValue();
        this.ignoreMalformedByDefault = builder.ignoreMalformed.getDefaultValue().value();
        this.coerceByDefault = builder.coerce.getDefaultValue().value();
    }

    boolean coerce() {
        return this.coerce.value();
    }

    boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    @Override
    public ScaledFloatFieldType fieldType() {
        return (ScaledFloatFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.ignoreMalformedByDefault, this.coerceByDefault).init(this);
    }

    @Override
    protected ScaledFloatFieldMapper clone() {
        return (ScaledFloatFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        double doubleValue;
        Object value;
        XContentParser parser = context.parser();
        Number numericValue = null;
        if (context.externalValueSet()) {
            value = context.externalValue();
        } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (this.coerce.value().booleanValue() && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            value = null;
        } else {
            try {
                numericValue = ScaledFloatFieldMapper.parse(parser, this.coerce.value());
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue()) {
                    return;
                }
                throw e;
            }
            value = numericValue;
        }
        if (value == null) {
            value = this.nullValue;
        }
        if (value == null) {
            return;
        }
        if (numericValue == null) {
            numericValue = ScaledFloatFieldMapper.parse(value);
        }
        if (!Double.isFinite(doubleValue = numericValue.doubleValue())) {
            if (this.ignoreMalformed.value().booleanValue()) {
                return;
            }
            throw new IllegalArgumentException("[scaled_float] only supports finite values, but got [" + doubleValue + "]");
        }
        long scaledValue = Math.round(doubleValue * this.scalingFactor);
        List<Field> fields = NumberFieldMapper.NumberType.LONG.createFields(this.fieldType().name(), scaledValue, this.indexed, this.hasDocValues, this.stored);
        context.doc().addAll(fields);
        if (!this.hasDocValues && (this.indexed || this.stored)) {
            this.createFieldNamesField(context);
        }
    }

    static Double parse(Object value) {
        return ScaledFloatFieldMapper.objectToDouble(value);
    }

    private static Double parse(XContentParser parser, boolean coerce) throws IOException {
        return parser.doubleValue(coerce);
    }

    private static double objectToDouble(Object value) {
        double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
        return doubleValue;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> indexed = ParametrizedFieldMapper.Parameter.indexParam(m3 -> ScaledFloatFieldMapper.toType((FieldMapper)m3).indexed, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m3 -> ScaledFloatFieldMapper.toType((FieldMapper)m3).hasDocValues, true);
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m3 -> ScaledFloatFieldMapper.toType((FieldMapper)m3).stored, false);
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final ParametrizedFieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final ParametrizedFieldMapper.Parameter<Double> scalingFactor = new ParametrizedFieldMapper.Parameter<Double>("scaling_factor", false, () -> null, (n, c, o) -> XContentMapValues.nodeDoubleValue(o), m3 -> ScaledFloatFieldMapper.toType((FieldMapper)m3).scalingFactor).setValidator(v -> {
            if (v == null) {
                throw new IllegalArgumentException("Field [scaling_factor] is required");
            }
            if (!Double.isFinite(v) || v <= 0.0) {
                throw new IllegalArgumentException("[scaling_factor] must be a positive number, got [" + v + "]");
            }
        });
        private final ParametrizedFieldMapper.Parameter<Double> nullValue = new ParametrizedFieldMapper.Parameter<Double>("null_value", false, () -> null, (n, c, o) -> o == null ? null : Double.valueOf(XContentMapValues.nodeDoubleValue(o)), m3 -> ScaledFloatFieldMapper.toType((FieldMapper)m3).nullValue).acceptsNull();
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name, Settings settings) {
            this(name, FieldMapper.IGNORE_MALFORMED_SETTING.get(settings), COERCE_SETTING.get(settings));
        }

        public Builder(String name, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.ignoreMalformed = ParametrizedFieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, m3 -> ScaledFloatFieldMapper.toType((FieldMapper)m3).ignoreMalformed, ignoreMalformedByDefault);
            this.coerce = ParametrizedFieldMapper.Parameter.explicitBoolParam("coerce", true, m3 -> ScaledFloatFieldMapper.toType((FieldMapper)m3).coerce, coerceByDefault);
        }

        Builder scalingFactor(double scalingFactor) {
            this.scalingFactor.setValue(scalingFactor);
            return this;
        }

        Builder nullValue(double nullValue) {
            this.nullValue.setValue(nullValue);
            return this;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.meta, this.scalingFactor, this.coerce, this.nullValue);
        }

        @Override
        public ScaledFloatFieldMapper build(Mapper.BuilderContext context) {
            ScaledFloatFieldType type = new ScaledFloatFieldType(this.buildFullName(context), this.indexed.getValue(), this.stored.getValue(), this.hasDocValues.getValue(), this.meta.getValue(), this.scalingFactor.getValue(), this.nullValue.getValue());
            return new ScaledFloatFieldMapper(this.name, type, this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static final class ScaledFloatFieldType
    extends SimpleMappedFieldType {
        private final double scalingFactor;
        private final Double nullValue;

        public ScaledFloatFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta, double scalingFactor, Double nullValue) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.scalingFactor = scalingFactor;
            this.nullValue = nullValue;
        }

        public ScaledFloatFieldType(String name, double scalingFactor) {
            this(name, true, false, true, Collections.emptyMap(), scalingFactor, null);
        }

        public double getScalingFactor() {
            return this.scalingFactor;
        }

        @Override
        public String typeName() {
            return ScaledFloatFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexed();
            long scaledValue = Math.round(this.scale(value));
            Query query = NumberFieldMapper.NumberType.LONG.termQuery(this.name(), scaledValue);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexed();
            ArrayList<Long> scaledValues = new ArrayList<Long>(values.size());
            for (Object value : values) {
                long scaledValue = Math.round(this.scale(value));
                scaledValues.add(scaledValue);
            }
            Query query = NumberFieldMapper.NumberType.LONG.termsQuery(this.name(), Collections.unmodifiableList(scaledValues));
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            this.failIfNotIndexed();
            Long lo = null;
            if (lowerTerm != null) {
                double dValue = this.scale(lowerTerm);
                if (!includeLower) {
                    dValue = Math.nextUp(dValue);
                }
                lo = Math.round(Math.ceil(dValue));
            }
            Long hi = null;
            if (upperTerm != null) {
                double dValue = this.scale(upperTerm);
                if (!includeUpper) {
                    dValue = Math.nextDown(dValue);
                }
                hi = Math.round(Math.floor(dValue));
            }
            Query query = NumberFieldMapper.NumberType.LONG.rangeQuery(this.name(), lo, hi, true, true, this.hasDocValues(), context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> {
                SortedNumericIndexFieldData scaledValues = new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG).build(cache, breakerService);
                return new ScaledFloatIndexFieldData(scaledValues, this.scalingFactor);
            };
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), mapperService){

                @Override
                protected Double parseSourceValue(Object value) {
                    double doubleValue;
                    if (value.equals("")) {
                        if (nullValue == null) {
                            return null;
                        }
                        doubleValue = nullValue;
                    } else {
                        doubleValue = ScaledFloatFieldMapper.objectToDouble(value);
                    }
                    double scalingFactor = this.getScalingFactor();
                    return (double)Math.round(doubleValue * scalingFactor) / scalingFactor;
                }
            };
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return (double)((Number)value).longValue() / this.scalingFactor;
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        private double scale(Object input) {
            return new BigDecimal(Double.toString(ScaledFloatFieldMapper.parse(input))).multiply(BigDecimal.valueOf(this.scalingFactor)).doubleValue();
        }
    }

    private static class ScaledFloatLeafFieldData
    implements LeafNumericFieldData {
        private final LeafNumericFieldData scaledFieldData;
        private final double scalingFactorInverse;

        ScaledFloatLeafFieldData(LeafNumericFieldData scaledFieldData, double scalingFactor) {
            this.scaledFieldData = scaledFieldData;
            this.scalingFactorInverse = 1.0 / scalingFactor;
        }

        public ScriptDocValues.Doubles getScriptValues() {
            return new ScriptDocValues.Doubles(this.getDoubleValues());
        }

        @Override
        public SortedBinaryDocValues getBytesValues() {
            return FieldData.toString(this.getDoubleValues());
        }

        public long ramBytesUsed() {
            return this.scaledFieldData.ramBytesUsed();
        }

        @Override
        public void close() {
            this.scaledFieldData.close();
        }

        @Override
        public SortedNumericDocValues getLongValues() {
            return FieldData.castToLong(this.getDoubleValues());
        }

        @Override
        public SortedNumericDoubleValues getDoubleValues() {
            final SortedNumericDocValues values = this.scaledFieldData.getLongValues();
            final NumericDocValues singleValues = DocValues.unwrapSingleton((SortedNumericDocValues)values);
            if (singleValues != null) {
                return FieldData.singleton(new NumericDoubleValues(){

                    public boolean advanceExact(int doc) throws IOException {
                        return singleValues.advanceExact(doc);
                    }

                    public double doubleValue() throws IOException {
                        return (double)singleValues.longValue() * scalingFactorInverse;
                    }
                });
            }
            return new SortedNumericDoubleValues(){

                @Override
                public boolean advanceExact(int target) throws IOException {
                    return values.advanceExact(target);
                }

                @Override
                public double nextValue() throws IOException {
                    return (double)values.nextValue() * scalingFactorInverse;
                }

                @Override
                public int docValueCount() {
                    return values.docValueCount();
                }
            };
        }

        @Override
        public DocValueFetcher.Leaf getLeafValueFetcher(final DocValueFormat format) {
            final SortedNumericDoubleValues values = this.getDoubleValues();
            return new DocValueFetcher.Leaf(){

                @Override
                public boolean advanceExact(int docId) throws IOException {
                    return values.advanceExact(docId);
                }

                @Override
                public int docValueCount() throws IOException {
                    return values.docValueCount();
                }

                @Override
                public Object nextValue() throws IOException {
                    return format.format(values.nextValue());
                }
            };
        }
    }

    private static class ScaledFloatIndexFieldData
    extends IndexNumericFieldData {
        private final IndexNumericFieldData scaledFieldData;
        private final double scalingFactor;

        ScaledFloatIndexFieldData(IndexNumericFieldData scaledFieldData, double scalingFactor) {
            this.scaledFieldData = scaledFieldData;
            this.scalingFactor = scalingFactor;
        }

        @Override
        public String getFieldName() {
            return this.scaledFieldData.getFieldName();
        }

        @Override
        public ValuesSourceType getValuesSourceType() {
            return this.scaledFieldData.getValuesSourceType();
        }

        @Override
        public LeafNumericFieldData load(LeafReaderContext context) {
            return new ScaledFloatLeafFieldData((LeafNumericFieldData)this.scaledFieldData.load(context), this.scalingFactor);
        }

        @Override
        public LeafNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
            return new ScaledFloatLeafFieldData((LeafNumericFieldData)this.scaledFieldData.loadDirect(context), this.scalingFactor);
        }

        @Override
        protected boolean sortRequiresCustomComparator() {
            return true;
        }

        @Override
        public IndexNumericFieldData.NumericType getNumericType() {
            return IndexNumericFieldData.NumericType.DOUBLE;
        }
    }
}

