/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.index.seqno;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.easysearch.ExceptionsHelper;
import org.easysearch.action.ActionListener;
import org.easysearch.action.support.ActionFilters;
import org.easysearch.action.support.ActiveShardCount;
import org.easysearch.action.support.WriteResponse;
import org.easysearch.action.support.replication.ReplicatedWriteRequest;
import org.easysearch.action.support.replication.ReplicationResponse;
import org.easysearch.action.support.replication.ReplicationTask;
import org.easysearch.action.support.replication.TransportReplicationAction;
import org.easysearch.action.support.replication.TransportWriteAction;
import org.easysearch.cluster.action.shard.ShardStateAction;
import org.easysearch.cluster.block.ClusterBlockLevel;
import org.easysearch.cluster.service.ClusterService;
import org.easysearch.common.inject.Inject;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.util.concurrent.ThreadContext;
import org.easysearch.index.IndexNotFoundException;
import org.easysearch.index.IndexingPressure;
import org.easysearch.index.seqno.RetentionLeases;
import org.easysearch.index.shard.IndexShard;
import org.easysearch.index.shard.IndexShardClosedException;
import org.easysearch.index.shard.ShardId;
import org.easysearch.indices.IndicesService;
import org.easysearch.indices.SystemIndices;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskId;
import org.easysearch.threadpool.ThreadPool;
import org.easysearch.transport.TransportException;
import org.easysearch.transport.TransportResponseHandler;
import org.easysearch.transport.TransportService;

public class RetentionLeaseSyncAction
extends TransportWriteAction<Request, Request, Response> {
    public static final String ACTION_NAME = "indices:admin/seq_no/retention_lease_sync";
    private static final Logger LOGGER = LogManager.getLogger(RetentionLeaseSyncAction.class);

    protected Logger getLogger() {
        return LOGGER;
    }

    @Inject
    public RetentionLeaseSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, IndexingPressure indexingPressure, SystemIndices systemIndices) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, Request::new, Request::new, ignore -> "management", false, indexingPressure, systemIndices);
    }

    @Override
    protected void doExecute(Task parentTask, Request request, ActionListener<Response> listener) {
        assert (false) : "use RetentionLeaseSyncAction#sync";
    }

    final void sync(final ShardId shardId, String primaryAllocationId, long primaryTerm, RetentionLeases retentionLeases, final ActionListener<ReplicationResponse> listener) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            Request request = new Request(shardId, retentionLeases);
            final ReplicationTask task = (ReplicationTask)this.taskManager.register("transport", "retention_lease_sync", request);
            this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<Request>(request, primaryAllocationId, primaryTerm), (Task)task, this.transportOptions, new TransportResponseHandler<ReplicationResponse>(){

                @Override
                public ReplicationResponse read(StreamInput in) throws IOException {
                    return RetentionLeaseSyncAction.this.newResponseInstance(in);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(ReplicationResponse response) {
                    task.setPhase("finished");
                    RetentionLeaseSyncAction.this.taskManager.unregister(task);
                    listener.onResponse(response);
                }

                @Override
                public void handleException(TransportException e) {
                    if (ExceptionsHelper.unwrap(e, IndexNotFoundException.class, AlreadyClosedException.class, IndexShardClosedException.class) == null) {
                        RetentionLeaseSyncAction.this.getLogger().warn((Message)new ParameterizedMessage("{} retention lease sync failed", (Object)shardId), (Throwable)e);
                    }
                    task.setPhase("finished");
                    RetentionLeaseSyncAction.this.taskManager.unregister(task);
                    listener.onFailure(e);
                }
            });
        }
    }

    @Override
    protected void dispatchedShardOperationOnPrimary(Request request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<Request, Response>> listener) {
        ActionListener.completeWith(listener, () -> {
            assert (request.waitForActiveShards().equals(ActiveShardCount.NONE)) : request.waitForActiveShards();
            Objects.requireNonNull(request);
            Objects.requireNonNull(primary);
            primary.persistRetentionLeases();
            return new TransportWriteAction.WritePrimaryResult<Request, Response>(request, new Response(), null, null, primary, this.getLogger());
        });
    }

    @Override
    protected void dispatchedShardOperationOnReplica(Request request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            Objects.requireNonNull(request);
            Objects.requireNonNull(replica);
            replica.updateRetentionLeasesOnReplica(request.getRetentionLeases());
            replica.persistRetentionLeases();
            return new TransportWriteAction.WriteReplicaResult<Request>(request, null, null, replica, this.getLogger());
        });
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    @Override
    protected Response newResponseInstance(StreamInput in) throws IOException {
        return new Response(in);
    }

    public static final class Request
    extends ReplicatedWriteRequest<Request> {
        private RetentionLeases retentionLeases;

        public RetentionLeases getRetentionLeases() {
            return this.retentionLeases;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.retentionLeases = new RetentionLeases(in);
        }

        public Request(ShardId shardId, RetentionLeases retentionLeases) {
            super(Objects.requireNonNull(shardId));
            this.retentionLeases = Objects.requireNonNull(retentionLeases);
            this.waitForActiveShards(ActiveShardCount.NONE);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(Objects.requireNonNull(out));
            this.retentionLeases.writeTo(out);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new ReplicationTask(id, type, action, "retention_lease_sync shardId=" + this.shardId, parentTaskId, headers);
        }

        @Override
        public String toString() {
            return "RetentionLeaseSyncAction.Request{retentionLeases=" + this.retentionLeases + ", shardId=" + this.shardId + ", timeout=" + this.timeout + ", index='" + this.index + "', waitForActiveShards=" + this.waitForActiveShards + "}";
        }
    }

    public static final class Response
    extends ReplicationResponse
    implements WriteResponse {
        public Response() {
        }

        Response(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public void setForcedRefresh(boolean forcedRefresh) {
        }
    }
}

