/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.join.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.easysearch.index.fielddata.IndexFieldData;
import org.easysearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.easysearch.index.mapper.FieldMapper;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.ParseContext;
import org.easysearch.index.mapper.StringFieldType;
import org.easysearch.index.mapper.TextSearchInfo;
import org.easysearch.index.mapper.ValueFetcher;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.support.CoreValuesSourceType;
import org.easysearch.search.lookup.SearchLookup;

public class MetaJoinFieldMapper
extends FieldMapper {
    static final String NAME = "_parent_join";
    static final String CONTENT_TYPE = "parent_join";

    MetaJoinFieldMapper(String name, String joinField) {
        super(name, Defaults.FIELD_TYPE, new MetaJoinFieldType(joinField), FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    @Override
    public MetaJoinFieldType fieldType() {
        return (MetaJoinFieldType)super.fieldType();
    }

    @Override
    protected MetaJoinFieldMapper clone() {
        return (MetaJoinFieldMapper)super.clone();
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new IllegalStateException("Should never be called");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        Defaults() {
        }

        static {
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.freeze();
        }
    }

    public static class MetaJoinFieldType
    extends StringFieldType {
        private final String joinField;

        private MetaJoinFieldType(String joinField) {
            super(MetaJoinFieldMapper.NAME, false, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
            this.joinField = joinField;
        }

        @Override
        public String typeName() {
            return MetaJoinFieldMapper.CONTENT_TYPE;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for metadata field [" + this.typeName() + "].");
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        public String getJoinField() {
            return this.joinField;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Exists query not supported for fields of type" + this.typeName());
        }
    }

    static class Builder
    extends FieldMapper.Builder<Builder> {
        final String joinField;

        Builder(String joinField) {
            super(MetaJoinFieldMapper.NAME, Defaults.FIELD_TYPE);
            this.builder = this;
            this.joinField = joinField;
        }

        @Override
        public MetaJoinFieldMapper build(Mapper.BuilderContext context) {
            return new MetaJoinFieldMapper(this.name, this.joinField);
        }
    }
}

