/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.monitor.jvm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.easysearch.common.settings.Setting;
import org.easysearch.common.settings.Settings;
import org.easysearch.common.unit.TimeValue;
import org.easysearch.monitor.jvm.JvmInfo;
import org.easysearch.monitor.jvm.JvmStats;
import org.easysearch.node.ReportingService;

public class JvmService
implements ReportingService<JvmInfo> {
    private static final Logger logger = LogManager.getLogger(JvmService.class);
    private final JvmInfo jvmInfo = JvmInfo.jvmInfo();
    private final TimeValue refreshInterval;
    private JvmStats jvmStats = JvmStats.jvmStats();
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.jvm.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public JvmService(Settings settings) {
        this.refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        logger.debug("using refresh_interval [{}]", (Object)this.refreshInterval);
    }

    @Override
    public JvmInfo info() {
        return this.jvmInfo;
    }

    public synchronized JvmStats stats() {
        if (System.currentTimeMillis() - this.jvmStats.getTimestamp() > this.refreshInterval.millis()) {
            this.jvmStats = JvmStats.jvmStats();
        }
        return this.jvmStats;
    }
}

