/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.easysearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.client.Requests;
import org.easysearch.client.node.NodeClient;
import org.easysearch.common.Strings;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestChannel;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.action.RestToXContentListener;

public class RestDeleteSnapshotAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.DELETE, "/_snapshot/{repository}/{snapshot}"));
    }

    @Override
    public String getName() {
        return "delete_snapshot_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        DeleteSnapshotRequest deleteSnapshotRequest = Requests.deleteSnapshotRequest(request.param("repository"), Strings.splitStringByCommaToArray(request.param("snapshot")));
        deleteSnapshotRequest.masterNodeTimeout(request.paramAsTime("master_timeout", deleteSnapshotRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().deleteSnapshot(deleteSnapshotRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

