/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.rest.action.admin.cluster.dangling;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.easysearch.action.ActionListener;
import org.easysearch.action.admin.indices.dangling.delete.DeleteDanglingIndexRequest;
import org.easysearch.action.support.master.AcknowledgedResponse;
import org.easysearch.client.node.NodeClient;
import org.easysearch.rest.BaseRestHandler;
import org.easysearch.rest.RestHandler;
import org.easysearch.rest.RestRequest;
import org.easysearch.rest.RestStatus;
import org.easysearch.rest.action.RestToXContentListener;

public class RestDeleteDanglingIndexAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.DELETE, "/_dangling/{index_uuid}"));
    }

    @Override
    public String getName() {
        return "delete_dangling_index";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        DeleteDanglingIndexRequest deleteRequest = new DeleteDanglingIndexRequest(request.param("index_uuid"), request.paramAsBoolean("accept_data_loss", false));
        deleteRequest.timeout(request.paramAsTime("timeout", deleteRequest.timeout()));
        deleteRequest.masterNodeTimeout(request.paramAsTime("master_timeout", deleteRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().deleteDanglingIndex(deleteRequest, (ActionListener<AcknowledgedResponse>)new RestToXContentListener<AcknowledgedResponse>(channel){

            @Override
            protected RestStatus getStatus(AcknowledgedResponse acknowledgedResponse) {
                return RestStatus.ACCEPTED;
            }
        });
    }
}

