/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.script;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.ToXContentFragment;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.script.ScriptCacheStats;
import org.easysearch.script.ScriptContextStats;

public class ScriptStats
implements Writeable,
ToXContentFragment {
    private final List<ScriptContextStats> contextStats;
    private final long compilations;
    private final long cacheEvictions;
    private final long compilationLimitTriggered;

    public ScriptStats(List<ScriptContextStats> contextStats) {
        ArrayList<ScriptContextStats> ctxStats = new ArrayList<ScriptContextStats>(contextStats.size());
        ctxStats.addAll(contextStats);
        ctxStats.sort(ScriptContextStats::compareTo);
        this.contextStats = Collections.unmodifiableList(ctxStats);
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        for (ScriptContextStats stats : contextStats) {
            compilations += stats.getCompilations();
            cacheEvictions += stats.getCacheEvictions();
            compilationLimitTriggered += stats.getCompilationLimitTriggered();
        }
        this.compilations = compilations;
        this.cacheEvictions = cacheEvictions;
        this.compilationLimitTriggered = compilationLimitTriggered;
    }

    public ScriptStats(long compilations, long cacheEvictions, long compilationLimitTriggered) {
        this.contextStats = Collections.emptyList();
        this.compilations = compilations;
        this.cacheEvictions = cacheEvictions;
        this.compilationLimitTriggered = compilationLimitTriggered;
    }

    public ScriptStats(ScriptContextStats context) {
        this(context.getCompilations(), context.getCacheEvictions(), context.getCompilationLimitTriggered());
    }

    public ScriptStats(StreamInput in) throws IOException {
        this.compilations = in.readVLong();
        this.cacheEvictions = in.readVLong();
        this.compilationLimitTriggered = in.readVLong();
        this.contextStats = in.readList(ScriptContextStats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.compilations);
        out.writeVLong(this.cacheEvictions);
        out.writeVLong(this.compilationLimitTriggered);
        out.writeList(this.contextStats);
    }

    public List<ScriptContextStats> getContextStats() {
        return this.contextStats;
    }

    public long getCompilations() {
        return this.compilations;
    }

    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    public long getCompilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    public ScriptCacheStats toScriptCacheStats() {
        if (this.contextStats.isEmpty()) {
            return new ScriptCacheStats(this);
        }
        HashMap<String, ScriptStats> contexts = new HashMap<String, ScriptStats>(this.contextStats.size());
        for (ScriptContextStats contextStats : this.contextStats) {
            contexts.put(contextStats.getContext(), new ScriptStats(contextStats));
        }
        return new ScriptCacheStats(contexts);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("script");
        builder.field("compilations", this.compilations);
        builder.field("cache_evictions", this.cacheEvictions);
        builder.field("compilation_limit_triggered", this.compilationLimitTriggered);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String SCRIPT_STATS = "script";
        static final String CONTEXTS = "contexts";
        static final String COMPILATIONS = "compilations";
        static final String CACHE_EVICTIONS = "cache_evictions";
        static final String COMPILATION_LIMIT_TRIGGERED = "compilation_limit_triggered";

        Fields() {
        }
    }
}

