/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.easysearch.EasysearchParseException;
import org.easysearch.common.ParseField;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.common.lease.Releasable;
import org.easysearch.common.xcontent.DeprecationHandler;
import org.easysearch.common.xcontent.XContentParser;
import org.easysearch.search.aggregations.AggregationBuilder;
import org.easysearch.search.aggregations.BucketCollector;
import org.easysearch.search.aggregations.InternalAggregation;
import org.easysearch.search.aggregations.support.AggregationPath;
import org.easysearch.search.internal.SearchContext;
import org.easysearch.search.sort.SortOrder;

public abstract class Aggregator
extends BucketCollector
implements Releasable {
    public abstract String name();

    public abstract SearchContext context();

    public abstract Aggregator parent();

    public abstract Aggregator subAggregator(String var1);

    public final Aggregator resolveSortPathOnValidAgg(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        Aggregator n = this.subAggregator(next.name);
        if (n == null) {
            throw new IllegalArgumentException("The provided aggregation [" + next + "] either does not exist, or is a pipeline aggregation and cannot be used to sort the buckets.");
        }
        if (!path.hasNext()) {
            return n;
        }
        if (next.key != null) {
            throw new IllegalArgumentException("Key only allowed on last aggregation path element but got [" + next + "]");
        }
        return n.resolveSortPath(path.next(), path);
    }

    public Aggregator resolveSortPath(AggregationPath.PathElement next, Iterator<AggregationPath.PathElement> path) {
        throw new IllegalArgumentException("Buckets can only be sorted on a sub-aggregator path that is built out of zero or more single-bucket aggregations within the path and a final single-bucket or a metrics aggregation at the path end. [" + this.name() + "] is not single-bucket.");
    }

    public BucketComparator bucketComparator(String key, SortOrder order) {
        throw new IllegalArgumentException("Buckets can only be sorted on a sub-aggregator path that is built out of zero or more single-bucket aggregations within the path and a final single-bucket or a metrics aggregation at the path end.");
    }

    public abstract InternalAggregation[] buildAggregations(long[] var1) throws IOException;

    public final InternalAggregation buildTopLevel() throws IOException {
        assert (this.parent() == null);
        return this.buildAggregations(new long[]{0L})[0];
    }

    public abstract InternalAggregation buildEmptyAggregation();

    public void collectDebugInfo(BiConsumer<String, Object> add) {
    }

    public static enum SubAggCollectionMode implements Writeable
    {
        DEPTH_FIRST(new ParseField("depth_first", new String[0])),
        BREADTH_FIRST(new ParseField("breadth_first", new String[0]));

        public static final ParseField KEY;
        private final ParseField parseField;

        private SubAggCollectionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        public ParseField parseField() {
            return this.parseField;
        }

        public static SubAggCollectionMode parse(String value, DeprecationHandler deprecationHandler) {
            SubAggCollectionMode[] modes;
            for (SubAggCollectionMode mode : modes = SubAggCollectionMode.values()) {
                if (!mode.parseField.match(value, deprecationHandler)) continue;
                return mode;
            }
            throw new EasysearchParseException("no [{}] found for value [{}]", KEY.getPreferredName(), value);
        }

        public static SubAggCollectionMode readFromStream(StreamInput in) throws IOException {
            return in.readEnum(SubAggCollectionMode.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        static {
            KEY = new ParseField("collect_mode", new String[0]);
        }
    }

    @FunctionalInterface
    public static interface BucketComparator {
        public int compare(long var1, long var3);
    }

    @FunctionalInterface
    public static interface Parser {
        public AggregationBuilder parse(String var1, XContentParser var2) throws IOException;
    }
}

