/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.bucket.terms.heuristic;

import java.io.IOException;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.xcontent.ObjectParser;
import org.easysearch.common.xcontent.ToXContent;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.easysearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristicBuilder;

public class JLHScore
extends SignificanceHeuristic {
    public static final String NAME = "jlh";
    public static final ObjectParser<JLHScore, Void> PARSER = new ObjectParser("jlh", JLHScore::new);

    public JLHScore() {
    }

    public JLHScore(StreamInput in) {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        double supersetProbability;
        double subsetProbability;
        double absoluteProbabilityChange;
        this.checkFrequencyValidity(subsetFreq, subsetSize, supersetFreq, supersetSize, "JLHScore");
        if (subsetSize == 0L || supersetSize == 0L) {
            return 0.0;
        }
        if (supersetFreq == 0L) {
            supersetFreq = 1L;
        }
        if ((absoluteProbabilityChange = (subsetProbability = (double)subsetFreq / (double)subsetSize) - (supersetProbability = (double)supersetFreq / (double)supersetSize)) <= 0.0) {
            return 0.0;
        }
        double relativeProbabilityChange = subsetProbability / supersetProbability;
        return absoluteProbabilityChange * relativeProbabilityChange;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME).endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class JLHScoreBuilder
    implements SignificanceHeuristicBuilder {
        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(JLHScore.NAME).endObject();
            return builder;
        }
    }
}

