/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.matrix.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.MultiValueMode;
import org.easysearch.search.aggregations.AggregationExecutionException;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.matrix.stats.MatrixStatsAggregator;
import org.easysearch.search.aggregations.support.ArrayValuesSourceAggregatorFactory;
import org.easysearch.search.aggregations.support.ValuesSource;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.internal.SearchContext;

final class MatrixStatsAggregatorFactory
extends ArrayValuesSourceAggregatorFactory {
    private final MultiValueMode multiValueMode;

    MatrixStatsAggregatorFactory(String name, Map<String, ValuesSourceConfig> configs, MultiValueMode multiValueMode, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, configs, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.multiValueMode = multiValueMode;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new MatrixStatsAggregator(this.name, null, searchContext, parent, this.multiValueMode, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(Map<String, ValuesSource> valuesSources, SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        HashMap<String, ValuesSource.Numeric> typedValuesSources = new HashMap<String, ValuesSource.Numeric>(valuesSources.size());
        for (Map.Entry<String, ValuesSource> entry : valuesSources.entrySet()) {
            if (!(entry.getValue() instanceof ValuesSource.Numeric)) {
                throw new AggregationExecutionException("ValuesSource type " + entry.getValue().toString() + "is not supported for aggregation " + this.name());
            }
            typedValuesSources.put(entry.getKey(), (ValuesSource.Numeric)entry.getValue());
        }
        return new MatrixStatsAggregator(this.name, typedValuesSources, searchContext, parent, this.multiValueMode, metadata);
    }
}

