/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.easysearch.index.query.QueryShardContext;
import org.easysearch.search.aggregations.Aggregator;
import org.easysearch.search.aggregations.AggregatorFactories;
import org.easysearch.search.aggregations.AggregatorFactory;
import org.easysearch.search.aggregations.CardinalityUpperBound;
import org.easysearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.easysearch.search.aggregations.metrics.PercentilesConfig;
import org.easysearch.search.aggregations.support.CoreValuesSourceType;
import org.easysearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.easysearch.search.aggregations.support.ValuesSourceConfig;
import org.easysearch.search.aggregations.support.ValuesSourceRegistry;
import org.easysearch.search.internal.SearchContext;

class PercentilesAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double[] percents;
    private final PercentilesConfig percentilesConfig;
    private final boolean keyed;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(PercentilesAggregationBuilder.REGISTRY_KEY, Arrays.asList(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), (name, valuesSource, context, parent, percents, percentilesConfig, keyed, formatter, metadata) -> percentilesConfig.createPercentilesAggregator(name, valuesSource, context, parent, percents, keyed, formatter, metadata), true);
    }

    PercentilesAggregatorFactory(String name, ValuesSourceConfig config, double[] percents, PercentilesConfig percentilesConfig, boolean keyed, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.percents = percents;
        this.percentilesConfig = percentilesConfig;
        this.keyed = keyed;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return this.percentilesConfig.createPercentilesAggregator(this.name, null, searchContext, parent, this.percents, this.keyed, this.config.format(), metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound bucketCardinality, Map<String, Object> metadata) throws IOException {
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(PercentilesAggregationBuilder.REGISTRY_KEY, this.config).build(this.name, this.config.getValuesSource(), searchContext, parent, this.percents, this.percentilesConfig, this.keyed, this.config.format(), metadata);
    }
}

