/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.fetch.subphase;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easysearch.index.mapper.FieldMapper;
import org.easysearch.index.mapper.MappedFieldType;
import org.easysearch.index.mapper.Mapper;
import org.easysearch.index.mapper.MapperService;
import org.easysearch.index.mapper.TextFieldMapper;
import org.easysearch.search.fetch.subphase.ReuseDocValueFetcher;

public class ReuseFietcherUtil {
    public static final Map<String, ReuseDocValueFetcher> genFetchers(MapperService mapperService, Map<String, ReuseDocValueFetcher> reuseFieldFetchers) {
        Map<String, Mapper> fieldMappers = mapperService.documentMapper().mappers().getFieldMappers();
        HashMap<String, String> multiFieldsNames = new HashMap<String, String>();
        Map<String, List<String>> skipPaths = mapperService.documentMapper().getSkipPaths();
        for (Map.Entry<String, Mapper> entry : fieldMappers.entrySet()) {
            TextFieldMapper textFieldMapper;
            String fullName = entry.getKey();
            if (fullName.startsWith("_")) continue;
            entry.getValue();
            if (Mapper.startsWithAny(fullName, skipPaths.keySet())) continue;
            if (entry.getValue().typeName().equals("text") && !(textFieldMapper = (TextFieldMapper)entry.getValue()).multiFields().isEmpty()) {
                for (Mapper mapper : textFieldMapper.multiFields()) {
                    if (!mapper.typeName().equals("keyword")) continue;
                    multiFieldsNames.put(mapper.name(), textFieldMapper.name());
                    break;
                }
            }
            MappedFieldType fieldType = ((FieldMapper)entry.getValue()).fieldType();
            if (!MapperService.reuseTypesContains(fieldType.typeName())) continue;
            ReuseFietcherUtil.addFetcher(fieldType, reuseFieldFetchers);
        }
        for (Map.Entry<String, Mapper> entry : multiFieldsNames.entrySet()) {
            String fName = entry.getKey();
            ReuseDocValueFetcher fetcher = reuseFieldFetchers.remove(fName);
            if (fetcher == null) continue;
            reuseFieldFetchers.put((String)((Object)entry.getValue()), fetcher);
        }
        return reuseFieldFetchers;
    }

    private static void addFetcher(MappedFieldType fieldType, Map<String, ReuseDocValueFetcher> reuseFieldFetchers) {
        reuseFieldFetchers.put(fieldType.name(), new ReuseDocValueFetcher(fieldType));
    }
}

