/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.common.io.stream.Writeable;
import org.easysearch.search.profile.aggregation.AggregationProfileShardResult;
import org.easysearch.search.profile.query.QueryProfileShardResult;

public class ProfileShardResult
implements Writeable {
    private final List<QueryProfileShardResult> queryProfileResults;
    private final AggregationProfileShardResult aggProfileShardResult;

    public ProfileShardResult(List<QueryProfileShardResult> queryProfileResults, AggregationProfileShardResult aggProfileShardResult) {
        this.aggProfileShardResult = aggProfileShardResult;
        this.queryProfileResults = Collections.unmodifiableList(queryProfileResults);
    }

    public ProfileShardResult(StreamInput in) throws IOException {
        int profileSize = in.readVInt();
        ArrayList<QueryProfileShardResult> queryProfileResults = new ArrayList<QueryProfileShardResult>(profileSize);
        for (int i = 0; i < profileSize; ++i) {
            QueryProfileShardResult result = new QueryProfileShardResult(in);
            queryProfileResults.add(result);
        }
        this.queryProfileResults = Collections.unmodifiableList(queryProfileResults);
        this.aggProfileShardResult = new AggregationProfileShardResult(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.queryProfileResults.size());
        for (QueryProfileShardResult queryShardResult : this.queryProfileResults) {
            queryShardResult.writeTo(out);
        }
        this.aggProfileShardResult.writeTo(out);
    }

    public List<QueryProfileShardResult> getQueryProfileResults() {
        return this.queryProfileResults;
    }

    public AggregationProfileShardResult getAggregationProfileResults() {
        return this.aggProfileShardResult;
    }
}

