/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreMode;
import org.easysearch.search.profile.query.CollectorResult;
import org.easysearch.search.profile.query.ProfileCollector;

public class InternalProfileCollector
implements Collector {
    private final String collectorName;
    private final String reason;
    private final ProfileCollector collector;
    private final List<InternalProfileCollector> children;

    public InternalProfileCollector(Collector collector, String reason, List<InternalProfileCollector> children) {
        this.collector = new ProfileCollector(collector);
        this.reason = reason;
        this.collectorName = this.deriveCollectorName(collector);
        this.children = children;
    }

    public long getTime() {
        return this.collector.getTime();
    }

    public String getReason() {
        return this.reason;
    }

    public String getName() {
        return this.collectorName;
    }

    private String deriveCollectorName(Collector c) {
        Object s2 = c.getClass().getSimpleName();
        if (((String)s2).equals("")) {
            s2 = c.getClass().getEnclosingClass().getSimpleName();
        }
        if (this.reason.equals("aggregation") || this.reason.equals("aggregation_global")) {
            s2 = (String)s2 + ": [" + c.toString() + "]";
        }
        return s2;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return this.collector.getLeafCollector(context);
    }

    public ScoreMode scoreMode() {
        return this.collector.scoreMode();
    }

    public CollectorResult getCollectorTree() {
        return InternalProfileCollector.doGetCollectorTree(this);
    }

    private static CollectorResult doGetCollectorTree(InternalProfileCollector collector) {
        ArrayList<CollectorResult> childResults = new ArrayList<CollectorResult>(collector.children.size());
        for (InternalProfileCollector child : collector.children) {
            CollectorResult result = InternalProfileCollector.doGetCollectorTree(child);
            childResults.add(result);
        }
        return new CollectorResult(collector.getName(), collector.getReason(), collector.getTime(), childResults);
    }
}

