/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.search.query;

import java.io.IOException;
import java.util.Map;
import org.easysearch.action.IndicesRequest;
import org.easysearch.action.OriginalIndices;
import org.easysearch.action.search.SearchShardTask;
import org.easysearch.action.support.IndicesOptions;
import org.easysearch.common.Nullable;
import org.easysearch.common.Strings;
import org.easysearch.common.io.stream.StreamInput;
import org.easysearch.common.io.stream.StreamOutput;
import org.easysearch.search.dfs.AggregatedDfs;
import org.easysearch.search.internal.ShardSearchContextId;
import org.easysearch.search.internal.ShardSearchRequest;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskId;
import org.easysearch.transport.TransportRequest;

public class QuerySearchRequest
extends TransportRequest
implements IndicesRequest {
    private final ShardSearchContextId contextId;
    private final AggregatedDfs dfs;
    private final OriginalIndices originalIndices;
    private final ShardSearchRequest shardSearchRequest;

    public QuerySearchRequest(OriginalIndices originalIndices, ShardSearchContextId contextId, ShardSearchRequest shardSearchRequest, AggregatedDfs dfs) {
        this.contextId = contextId;
        this.dfs = dfs;
        this.shardSearchRequest = shardSearchRequest;
        this.originalIndices = originalIndices;
    }

    public QuerySearchRequest(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        this.dfs = new AggregatedDfs(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
        this.shardSearchRequest = in.readOptionalWriteable(ShardSearchRequest::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.contextId.writeTo(out);
        this.dfs.writeTo(out);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
        out.writeOptionalWriteable(this.shardSearchRequest);
    }

    public ShardSearchContextId contextId() {
        return this.contextId;
    }

    public AggregatedDfs dfs() {
        return this.dfs;
    }

    @Nullable
    public ShardSearchRequest shardSearchRequest() {
        return this.shardSearchRequest;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("id[");
        sb.append(this.contextId);
        sb.append("], ");
        sb.append("indices[");
        Strings.arrayToDelimitedString(this.originalIndices.indices(), ",", sb);
        sb.append("]");
        return sb.toString();
    }
}

