/*
 * Decompiled with CFR 0.152.
 */
package org.easysearch.tasks;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.easysearch.common.Nullable;
import org.easysearch.tasks.Task;
import org.easysearch.tasks.TaskId;

public abstract class CancellableTask
extends Task {
    private volatile String reason;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        super(id, type, action, description, parentTaskId, headers);
    }

    final void cancel(String reason) {
        assert (reason != null);
        if (this.cancelled.compareAndSet(false, true)) {
            this.reason = reason;
            this.onCancelled();
        }
    }

    public boolean cancelOnParentLeaving() {
        return true;
    }

    public boolean shouldCancelChildrenOnCancellation() {
        return true;
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Nullable
    public final String getReasonCancelled() {
        return this.reason;
    }

    protected void onCancelled() {
    }
}

