/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto;

import org.apache.seatunnel.connectors.seatunnel.elasticsearch.constant.ElasticsearchVersion;
import org.apache.seatunnel.shade.com.google.common.base.Strings;

public class ElasticsearchClusterInfo {
    private String distribution;
    private String clusterVersion;

    public ElasticsearchVersion getElasticsearchVersion() {
        return ElasticsearchVersion.get(this.clusterVersion);
    }

    public boolean isOpensearch() {
        return !Strings.isNullOrEmpty((String)this.distribution) && "opensearch".equalsIgnoreCase(this.distribution);
    }

    ElasticsearchClusterInfo(String distribution, String clusterVersion) {
        this.distribution = distribution;
        this.clusterVersion = clusterVersion;
    }

    public static ElasticsearchClusterInfoBuilder builder() {
        return new ElasticsearchClusterInfoBuilder();
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public String toString() {
        return "ElasticsearchClusterInfo(distribution=" + this.getDistribution() + ", clusterVersion=" + this.getClusterVersion() + ")";
    }

    public static class ElasticsearchClusterInfoBuilder {
        private String distribution;
        private String clusterVersion;

        ElasticsearchClusterInfoBuilder() {
        }

        public ElasticsearchClusterInfoBuilder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        public ElasticsearchClusterInfoBuilder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public ElasticsearchClusterInfo build() {
            return new ElasticsearchClusterInfo(this.distribution, this.clusterVersion);
        }

        public String toString() {
            return "ElasticsearchClusterInfo.ElasticsearchClusterInfoBuilder(distribution=" + this.distribution + ", clusterVersion=" + this.clusterVersion + ")";
        }
    }
}

