/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto;

import java.util.Arrays;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SinkConfig;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class IndexInfo {
    private String index;
    private String type;
    private String[] primaryKeys;
    private String keyDelimiter;

    public IndexInfo(Config pluginConfig) {
        this.index = pluginConfig.getString(SinkConfig.INDEX.key());
        if (pluginConfig.hasPath(SinkConfig.INDEX_TYPE.key())) {
            this.type = pluginConfig.getString(SinkConfig.INDEX_TYPE.key());
        }
        if (pluginConfig.hasPath(SinkConfig.PRIMARY_KEYS.key())) {
            this.primaryKeys = pluginConfig.getStringList(SinkConfig.PRIMARY_KEYS.key()).toArray(new String[0]);
        }
        this.keyDelimiter = (String)SinkConfig.KEY_DELIMITER.defaultValue();
        if (pluginConfig.hasPath(SinkConfig.KEY_DELIMITER.key())) {
            this.keyDelimiter = pluginConfig.getString(SinkConfig.KEY_DELIMITER.key());
        }
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String[] getPrimaryKeys() {
        return this.primaryKeys;
    }

    public String getKeyDelimiter() {
        return this.keyDelimiter;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPrimaryKeys(String[] primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void setKeyDelimiter(String keyDelimiter) {
        this.keyDelimiter = keyDelimiter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexInfo)) {
            return false;
        }
        IndexInfo other = (IndexInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPrimaryKeys(), other.getPrimaryKeys())) {
            return false;
        }
        String this$keyDelimiter = this.getKeyDelimiter();
        String other$keyDelimiter = other.getKeyDelimiter();
        return !(this$keyDelimiter == null ? other$keyDelimiter != null : !this$keyDelimiter.equals(other$keyDelimiter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPrimaryKeys());
        String $keyDelimiter = this.getKeyDelimiter();
        result = result * 59 + ($keyDelimiter == null ? 43 : $keyDelimiter.hashCode());
        return result;
    }

    public String toString() {
        return "IndexInfo(index=" + this.getIndex() + ", type=" + this.getType() + ", primaryKeys=" + Arrays.deepToString(this.getPrimaryKeys()) + ", keyDelimiter=" + this.getKeyDelimiter() + ")";
    }
}

