/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize;

import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.ElasticsearchClusterInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.IndexInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorException;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.KeyExtractor;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.SeaTunnelRowSerializer;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.index.IndexSerializer;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.index.IndexSerializerFactory;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.type.IndexTypeSerializer;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.type.IndexTypeSerializerFactory;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class ElasticsearchRowSerializer
implements SeaTunnelRowSerializer {
    private final SeaTunnelRowType seaTunnelRowType;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final IndexSerializer indexSerializer;
    private final IndexTypeSerializer indexTypeSerializer;
    private final Function<SeaTunnelRow, String> keyExtractor;

    public ElasticsearchRowSerializer(ElasticsearchClusterInfo elasticsearchClusterInfo, IndexInfo indexInfo, SeaTunnelRowType seaTunnelRowType) {
        this.indexTypeSerializer = IndexTypeSerializerFactory.getIndexTypeSerializer(elasticsearchClusterInfo, indexInfo.getType());
        this.indexSerializer = IndexSerializerFactory.getIndexSerializer(indexInfo.getIndex(), seaTunnelRowType);
        this.seaTunnelRowType = seaTunnelRowType;
        this.keyExtractor = KeyExtractor.createKeyExtractor(seaTunnelRowType, indexInfo.getPrimaryKeys(), indexInfo.getKeyDelimiter());
    }

    @Override
    public String serializeRow(SeaTunnelRow row) {
        switch (row.getRowKind()) {
            case INSERT: 
            case UPDATE_AFTER: {
                return this.serializeUpsert(row);
            }
            case UPDATE_BEFORE: 
            case DELETE: {
                return this.serializeDelete(row);
            }
        }
        throw new ElasticsearchConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, "Unsupported write row kind: " + row.getRowKind());
    }

    private String serializeUpsert(SeaTunnelRow row) {
        String key = this.keyExtractor.apply(row);
        Map<String, Object> document = this.toDocumentMap(row);
        try {
            if (key != null) {
                Map<String, String> upsertMetadata = this.createMetadata(row, key);
                return "{ \"update\" :" + this.objectMapper.writeValueAsString(upsertMetadata) + "}" + "\n" + "{ \"doc\" :" + this.objectMapper.writeValueAsString(document) + ", \"doc_as_upsert\" : true }";
            }
            Map<String, String> indexMetadata = this.createMetadata(row);
            return "{ \"index\" :" + this.objectMapper.writeValueAsString(indexMetadata) + "}" + "\n" + this.objectMapper.writeValueAsString(document);
        }
        catch (JsonProcessingException e) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)CommonErrorCode.JSON_OPERATION_FAILED, "Object json deserialization exception.", e);
        }
    }

    private String serializeDelete(SeaTunnelRow row) {
        String key = this.keyExtractor.apply(row);
        Map<String, String> deleteMetadata = this.createMetadata(row, key);
        try {
            return "{ \"delete\" :" + this.objectMapper.writeValueAsString(deleteMetadata) + "}";
        }
        catch (JsonProcessingException e) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)CommonErrorCode.JSON_OPERATION_FAILED, "Object json deserialization exception.", e);
        }
    }

    private Map<String, Object> toDocumentMap(SeaTunnelRow row) {
        String[] fieldNames = this.seaTunnelRowType.getFieldNames();
        HashMap<String, Object> doc = new HashMap<String, Object>(fieldNames.length);
        Object[] fields = row.getFields();
        for (int i = 0; i < fieldNames.length; ++i) {
            Object value = fields[i];
            if (value instanceof Temporal) {
                doc.put(fieldNames[i], value.toString());
                continue;
            }
            doc.put(fieldNames[i], value);
        }
        return doc;
    }

    private Map<String, String> createMetadata(@NonNull SeaTunnelRow row, @NonNull String key) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Map<String, String> actionMetadata = this.createMetadata(row);
        actionMetadata.put("_id", key);
        return actionMetadata;
    }

    private Map<String, String> createMetadata(@NonNull SeaTunnelRow row) {
        if (row == null) {
            throw new NullPointerException("row is marked non-null but is null");
        }
        HashMap<String, String> actionMetadata = new HashMap<String, String>(2);
        actionMetadata.put("_index", this.indexSerializer.serialize(row));
        this.indexTypeSerializer.fillType(actionMetadata);
        return actionMetadata;
    }
}

