/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.source;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.catalog.ElasticSearchDataTypeConvertor;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.EsRestClient;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceReader;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceState;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSource.class})
public class ElasticsearchSource
implements SeaTunnelSource<SeaTunnelRow, ElasticsearchSourceSplit, ElasticsearchSourceState>,
SupportParallelism,
SupportColumnProjection {
    private Config pluginConfig;
    private SeaTunnelRowType rowTypeInfo;
    private List<String> source;

    public String getPluginName() {
        return "Elasticsearch";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        this.pluginConfig = pluginConfig;
        if (pluginConfig.hasPath(CatalogTableUtil.SCHEMA.key())) {
            this.rowTypeInfo = CatalogTableUtil.buildWithConfig((Config)pluginConfig).getSeaTunnelRowType();
            this.source = Arrays.asList(this.rowTypeInfo.getFieldNames());
        } else {
            this.source = pluginConfig.getStringList(SourceConfig.SOURCE.key());
            EsRestClient esRestClient = EsRestClient.createInstance(this.pluginConfig);
            Map<String, String> esFieldType = esRestClient.getFieldTypeMapping(pluginConfig.getString(SourceConfig.INDEX.key()), this.source);
            esRestClient.close();
            SeaTunnelDataType[] fieldTypes = new SeaTunnelDataType[this.source.size()];
            ElasticSearchDataTypeConvertor elasticSearchDataTypeConvertor = new ElasticSearchDataTypeConvertor();
            for (int i = 0; i < this.source.size(); ++i) {
                SeaTunnelDataType<?> seaTunnelDataType;
                String esType = esFieldType.get(this.source.get(i));
                fieldTypes[i] = seaTunnelDataType = elasticSearchDataTypeConvertor.toSeaTunnelType(esType);
            }
            this.rowTypeInfo = new SeaTunnelRowType(this.source.toArray(new String[0]), fieldTypes);
        }
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.rowTypeInfo;
    }

    public SourceReader<SeaTunnelRow, ElasticsearchSourceSplit> createReader(SourceReader.Context readerContext) {
        return new ElasticsearchSourceReader(readerContext, this.pluginConfig, this.rowTypeInfo);
    }

    public SourceSplitEnumerator<ElasticsearchSourceSplit, ElasticsearchSourceState> createEnumerator(SourceSplitEnumerator.Context<ElasticsearchSourceSplit> enumeratorContext) {
        return new ElasticsearchSourceSplitEnumerator(enumeratorContext, this.pluginConfig, this.source);
    }

    public SourceSplitEnumerator<ElasticsearchSourceSplit, ElasticsearchSourceState> restoreEnumerator(SourceSplitEnumerator.Context<ElasticsearchSourceSplit> enumeratorContext, ElasticsearchSourceState sourceState) {
        return new ElasticsearchSourceSplitEnumerator(enumeratorContext, sourceState, this.pluginConfig, this.source);
    }
}

