/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.util.ConfigUtil;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.catalog.ElasticSearchDataTypeConvertor;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.EsRestClient;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.ElasticsearchClusterInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.source.IndexDocsCount;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchCatalog
implements Catalog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchCatalog.class);
    private final String catalogName;
    private final String defaultDatabase;
    private final Config pluginConfig;
    private EsRestClient esRestClient;

    public ElasticSearchCatalog(String catalogName, String defaultDatabase, Config elasticSearchConfig) {
        this.catalogName = Preconditions.checkNotNull(catalogName, "catalogName cannot be null");
        this.defaultDatabase = defaultDatabase;
        this.pluginConfig = Preconditions.checkNotNull(elasticSearchConfig, "elasticSearchConfig cannot be null");
    }

    public void open() throws CatalogException {
        try {
            this.esRestClient = EsRestClient.createInstance(this.pluginConfig);
            ElasticsearchClusterInfo elasticsearchClusterInfo = this.esRestClient.getClusterInfo();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Success open es catalog: {}, cluster info: {}", (Object)this.catalogName, (Object)elasticsearchClusterInfo);
            }
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed to open catalog %s", this.catalogName), (Throwable)e);
        }
    }

    public void close() throws CatalogException {
        this.esRestClient.close();
    }

    public String getDefaultDatabase() throws CatalogException {
        return this.defaultDatabase;
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            List<IndexDocsCount> indexDocsCount = this.esRestClient.getIndexDocsCount(databaseName);
            return true;
        }
        catch (Exception e) {
            throw new CatalogException(String.format("Failed to check if catalog %s database %s exists", this.catalogName, databaseName), (Throwable)e);
        }
    }

    public List<String> listDatabases() throws CatalogException {
        return this.esRestClient.listIndex();
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.catalogName, databaseName);
        }
        return Lists.newArrayList(databaseName);
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        Preconditions.checkNotNull(tablePath);
        return this.databaseExists(tablePath.getTableName());
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        Preconditions.checkNotNull(tablePath, "tablePath cannot be null");
        ElasticSearchDataTypeConvertor elasticSearchDataTypeConvertor = new ElasticSearchDataTypeConvertor();
        TableSchema.Builder builder = TableSchema.builder();
        Map<String, String> fieldTypeMapping = this.esRestClient.getFieldTypeMapping(tablePath.getTableName(), Collections.emptyList());
        fieldTypeMapping.forEach((fieldName, fieldType) -> {
            PhysicalColumn physicalColumn = PhysicalColumn.of((String)fieldName, elasticSearchDataTypeConvertor.toSeaTunnelType((String)fieldType), null, (boolean)true, null, null);
            builder.column((Column)physicalColumn);
        });
        return CatalogTable.of((TableIdentifier)TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName()), (TableSchema)builder.build(), this.buildTableOptions(tablePath), Collections.emptyList(), (String)"");
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath, "tablePath cannot be null");
        if (this.tableExists(tablePath)) {
            if (ignoreIfExists) {
                return;
            }
            throw new TableAlreadyExistException(this.catalogName, tablePath, null);
        }
        this.esRestClient.createIndex(tablePath.getTableName());
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath);
        if (!this.tableExists(tablePath) && !ignoreIfNotExists) {
            throw new TableNotExistException(this.catalogName, tablePath);
        }
        try {
            this.esRestClient.dropIndex(tablePath.getTableName());
        }
        catch (Exception ex) {
            throw new CatalogException(String.format("Failed to drop table %s in catalog %s", tablePath.getTableName(), this.catalogName), (Throwable)ex);
        }
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        this.createTable(tablePath, null, ignoreIfExists);
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        this.dropTable(tablePath, ignoreIfNotExists);
    }

    private Map<String, String> buildTableOptions(TablePath tablePath) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("connector", "elasticsearch");
        options.put("config", ConfigUtil.convertToJsonString((Object)tablePath));
        return options;
    }
}

