/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.common.multitablesink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.sink.MultiTableResourceManager;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SupportMultiTableSinkAggregatedCommitter;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.MultiTableAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.MultiTableCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.common.multitablesink.SinkIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableSinkAggregatedCommitter
implements SinkAggregatedCommitter<MultiTableCommitInfo, MultiTableAggregatedCommitInfo> {
    private static final Logger log = LoggerFactory.getLogger(MultiTableSinkAggregatedCommitter.class);
    private final Map<String, SinkAggregatedCommitter<?, ?>> aggCommitters;
    private transient MultiTableResourceManager resourceManager = null;

    public MultiTableSinkAggregatedCommitter(Map<String, SinkAggregatedCommitter<?, ?>> aggCommitters) {
        this.aggCommitters = aggCommitters;
    }

    public void init() {
        this.initResourceManager();
    }

    private void initResourceManager() {
        SinkAggregatedCommitter<?, ?> aggCommitter;
        Iterator<String> iterator = this.aggCommitters.keySet().iterator();
        if (iterator.hasNext()) {
            String tableIdentifier = iterator.next();
            aggCommitter = this.aggCommitters.get(tableIdentifier);
            if (!(aggCommitter instanceof SupportMultiTableSinkAggregatedCommitter)) {
                return;
            }
            this.resourceManager = ((SupportMultiTableSinkAggregatedCommitter)aggCommitter).initMultiTableResourceManager(this.aggCommitters.size(), 1);
        }
        if (this.resourceManager != null) {
            for (String tableIdentifier : this.aggCommitters.keySet()) {
                aggCommitter = this.aggCommitters.get(tableIdentifier);
                aggCommitter.init();
                ((SupportMultiTableSinkAggregatedCommitter)aggCommitter).setMultiTableResourceManager(this.resourceManager, 0);
            }
        }
    }

    public List<MultiTableAggregatedCommitInfo> commit(List<MultiTableAggregatedCommitInfo> aggregatedCommitInfo) throws IOException {
        ArrayList<MultiTableAggregatedCommitInfo> errorList = new ArrayList<MultiTableAggregatedCommitInfo>();
        for (String sinkIdentifier : this.aggCommitters.keySet()) {
            List commitInfo;
            List errCommitList;
            SinkAggregatedCommitter<?, ?> sinkCommitter = this.aggCommitters.get(sinkIdentifier);
            if (sinkCommitter == null || (errCommitList = sinkCommitter.commit(commitInfo = aggregatedCommitInfo.stream().map(multiTableCommitInfo -> multiTableCommitInfo.getCommitInfo().get(sinkIdentifier)).filter(Objects::nonNull).collect(Collectors.toList()))).size() == 0) continue;
            for (int i = 0; i < errCommitList.size(); ++i) {
                if (errorList.size() < i + 1) {
                    errorList.add(i, new MultiTableAggregatedCommitInfo(new HashMap<String, Object>()));
                }
                ((MultiTableAggregatedCommitInfo)errorList.get(i)).getCommitInfo().put(sinkIdentifier, errCommitList.get(i));
            }
        }
        return errorList;
    }

    public MultiTableAggregatedCommitInfo combine(List<MultiTableCommitInfo> commitInfos) {
        HashMap<String, Object> commitInfo = new HashMap<String, Object>();
        for (String sinkIdentifier : this.aggCommitters.keySet()) {
            SinkAggregatedCommitter<?, ?> sinkCommitter = this.aggCommitters.get(sinkIdentifier);
            if (sinkCommitter == null) continue;
            List commits = commitInfos.stream().flatMap(multiTableCommitInfo -> multiTableCommitInfo.getCommitInfo().entrySet().stream().filter(m3 -> ((SinkIdentifier)m3.getKey()).getTableIdentifier().equals(sinkIdentifier)).map(Map.Entry::getValue)).collect(Collectors.toList());
            commitInfo.put(sinkIdentifier, sinkCommitter.combine(commits));
        }
        return new MultiTableAggregatedCommitInfo(commitInfo);
    }

    public void abort(List<MultiTableAggregatedCommitInfo> aggregatedCommitInfo) throws Exception {
        Throwable firstE = null;
        for (String sinkIdentifier : this.aggCommitters.keySet()) {
            SinkAggregatedCommitter<?, ?> sinkCommitter = this.aggCommitters.get(sinkIdentifier);
            if (sinkCommitter == null) continue;
            List commitInfo = aggregatedCommitInfo.stream().map(multiTableCommitInfo -> multiTableCommitInfo.getCommitInfo().get(sinkIdentifier)).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                sinkCommitter.abort(commitInfo);
            }
            catch (Throwable e) {
                log.error("abort sink committer error", e);
                if (firstE != null) continue;
                firstE = e;
            }
        }
        if (firstE != null) {
            throw new RuntimeException(firstE);
        }
    }

    public void close() throws IOException {
        Throwable firstE = null;
        for (String sinkIdentifier : this.aggCommitters.keySet()) {
            SinkAggregatedCommitter<?, ?> sinkCommitter = this.aggCommitters.get(sinkIdentifier);
            if (sinkCommitter == null) continue;
            try {
                sinkCommitter.close();
            }
            catch (Throwable e) {
                log.error("close sink committer error", e);
                if (firstE != null) continue;
                firstE = e;
            }
        }
        if (firstE != null) {
            throw new RuntimeException(firstE);
        }
        try {
            if (this.resourceManager != null) {
                this.resourceManager.close();
            }
        }
        catch (Throwable e) {
            log.error("close resourceManager error", e);
        }
    }
}

