/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.Asserts;
import org.apache.http.util.EntityUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.EsClusterConnectionConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.BulkResponse;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.ElasticsearchClusterInfo;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.source.IndexDocsCount;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.dto.source.ScrollResult;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorException;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.util.SSLUtils;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.TextNode;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsRestClient {
    private static final Logger log = LoggerFactory.getLogger(EsRestClient.class);
    private static final int CONNECTION_REQUEST_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 300000;
    private final RestClient restClient;

    private EsRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public static EsRestClient createInstance(ReadonlyConfig config) {
        List hosts = (List)config.get(EsClusterConnectionConfig.HOSTS);
        Optional username = config.getOptional(EsClusterConnectionConfig.USERNAME);
        Optional password = config.getOptional(EsClusterConnectionConfig.PASSWORD);
        Optional keystorePath = Optional.empty();
        Optional keystorePassword = Optional.empty();
        Optional truststorePath = Optional.empty();
        Optional truststorePassword = Optional.empty();
        boolean tlsVerifyCertificate = (Boolean)config.get(EsClusterConnectionConfig.TLS_VERIFY_CERTIFICATE);
        if (tlsVerifyCertificate) {
            keystorePath = config.getOptional(EsClusterConnectionConfig.TLS_KEY_STORE_PATH);
            keystorePassword = config.getOptional(EsClusterConnectionConfig.TLS_KEY_STORE_PASSWORD);
            truststorePath = config.getOptional(EsClusterConnectionConfig.TLS_TRUST_STORE_PATH);
            truststorePassword = config.getOptional(EsClusterConnectionConfig.TLS_TRUST_STORE_PASSWORD);
        }
        boolean tlsVerifyHostnames = (Boolean)config.get(EsClusterConnectionConfig.TLS_VERIFY_HOSTNAME);
        return EsRestClient.createInstance(hosts, username, password, tlsVerifyCertificate, tlsVerifyHostnames, keystorePath, keystorePassword, truststorePath, truststorePassword);
    }

    public static EsRestClient createInstance(List<String> hosts, Optional<String> username, Optional<String> password, boolean tlsVerifyCertificate, boolean tlsVerifyHostnames, Optional<String> keystorePath, Optional<String> keystorePassword, Optional<String> truststorePath, Optional<String> truststorePassword) {
        RestClientBuilder restClientBuilder = EsRestClient.getRestClientBuilder(hosts, username, password, tlsVerifyCertificate, tlsVerifyHostnames, keystorePath, keystorePassword, truststorePath, truststorePassword);
        return new EsRestClient(restClientBuilder.build());
    }

    private static RestClientBuilder getRestClientBuilder(List<String> hosts, Optional<String> username, Optional<String> password, boolean tlsVerifyCertificate, boolean tlsVerifyHostnames, Optional<String> keystorePath, Optional<String> keystorePassword, Optional<String> truststorePath, Optional<String> truststorePassword) {
        HttpHost[] httpHosts = new HttpHost[hosts.size()];
        for (int i = 0; i < hosts.size(); ++i) {
            httpHosts[i] = HttpHost.create(hosts.get(i));
        }
        RestClientBuilder restClientBuilder = RestClient.builder(httpHosts).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectionRequestTimeout(10000).setSocketTimeout(300000));
        restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
            if (username.isPresent()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials((String)username.get(), (String)password.get()));
                httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
            try {
                Object sslContext;
                if (tlsVerifyCertificate) {
                    sslContext = SSLUtils.buildSSLContext(keystorePath, keystorePassword, truststorePath, truststorePassword);
                    ((Optional)sslContext).ifPresent(e -> httpClientBuilder.setSSLContext((SSLContext)e));
                } else {
                    sslContext = SSLContexts.custom().loadTrustMaterial(new TrustAllStrategy()).build();
                    httpClientBuilder.setSSLContext((SSLContext)sslContext);
                }
                if (!tlsVerifyHostnames) {
                    httpClientBuilder.setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE);
                }
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            return httpClientBuilder;
        });
        return restClientBuilder;
    }

    public BulkResponse bulk(String requestBody) {
        Request request = new Request("POST", "/_bulk");
        request.setJsonEntity(requestBody);
        try {
            Response response = this.restClient.performRequest(request);
            if (response == null) {
                throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.BULK_RESPONSE_ERROR, "bulk es Response is null");
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                ObjectMapper objectMapper = new ObjectMapper();
                String entity = EntityUtils.toString(response.getEntity());
                JsonNode json = objectMapper.readTree(entity);
                int took = json.get("took").asInt();
                boolean errors = json.get("errors").asBoolean();
                return new BulkResponse(errors, took, entity);
            }
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.BULK_RESPONSE_ERROR, String.format("bulk es response status code=%d,request boy=%s", response.getStatusLine().getStatusCode(), requestBody));
        }
        catch (IOException e) {
            throw new ElasticsearchConnectorException(ElasticsearchConnectorErrorCode.BULK_RESPONSE_ERROR, String.format("bulk es error,request boy=%s", requestBody), e);
        }
    }

    public ElasticsearchClusterInfo getClusterInfo() {
        Request request = new Request("GET", "/");
        try {
            Response response = this.restClient.performRequest(request);
            String result = EntityUtils.toString(response.getEntity());
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(result);
            JsonNode versionNode = jsonNode.get("version");
            return ElasticsearchClusterInfo.builder().clusterVersion(versionNode.get("number").asText()).distribution(Optional.ofNullable(versionNode.get("distribution")).map(e -> e.asText()).orElse(null)).build();
        }
        catch (IOException e2) {
            throw new ElasticsearchConnectorException(ElasticsearchConnectorErrorCode.GET_ES_VERSION_FAILED, "fail to get elasticsearch version.", e2);
        }
    }

    public void close() {
        try {
            this.restClient.close();
        }
        catch (IOException e) {
            log.warn("close elasticsearch connection error", (Throwable)e);
        }
    }

    public ScrollResult searchByScroll(String index, List<String> source, Map<String, Object> query, String scrollTime, int scrollSize) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("query", query);
        param.put("_source", source);
        param.put("sort", new String[]{"_doc"});
        param.put("size", scrollSize);
        String endpoint = "/" + index + "/_search?scroll=" + scrollTime;
        ScrollResult scrollResult = this.getDocsFromScrollRequest(endpoint, JsonUtils.toJsonString(param));
        return scrollResult;
    }

    public ScrollResult searchWithScrollId(String scrollId, String scrollTime) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("scroll_id", scrollId);
        param.put("scroll", scrollTime);
        ScrollResult scrollResult = this.getDocsFromScrollRequest("/_search/scroll", JsonUtils.toJsonString(param));
        return scrollResult;
    }

    private ScrollResult getDocsFromScrollRequest(String endpoint, String requestBody) {
        Request request = new Request("POST", endpoint);
        request.setJsonEntity(requestBody);
        try {
            Response response = this.restClient.performRequest(request);
            if (response == null) {
                throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.SCROLL_REQUEST_ERROR, "POST " + endpoint + " response null");
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                int successful;
                String entity = EntityUtils.toString(response.getEntity());
                ObjectNode responseJson = JsonUtils.parseObject((String)entity);
                JsonNode shards = responseJson.get("_shards");
                int totalShards = shards.get("total").intValue();
                Asserts.check(totalShards == (successful = shards.get("successful").intValue()), String.format("POST %s,total shards(%d)!= successful shards(%d)", endpoint, totalShards, successful));
                ScrollResult scrollResult = this.getDocsFromScrollResponse(responseJson);
                return scrollResult;
            }
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.SCROLL_REQUEST_ERROR, String.format("POST %s response status code=%d,request boy=%s", endpoint, response.getStatusLine().getStatusCode(), requestBody));
        }
        catch (IOException e) {
            throw new ElasticsearchConnectorException(ElasticsearchConnectorErrorCode.SCROLL_REQUEST_ERROR, String.format("POST %s error,request boy=%s", endpoint, requestBody), e);
        }
    }

    private ScrollResult getDocsFromScrollResponse(ObjectNode responseJson) {
        ScrollResult scrollResult = new ScrollResult();
        String scrollId = responseJson.get("_scroll_id").asText();
        scrollResult.setScrollId(scrollId);
        JsonNode hitsNode = responseJson.get("hits").get("hits");
        ArrayList<Map<String, Object>> docs = new ArrayList<Map<String, Object>>(hitsNode.size());
        scrollResult.setDocs(docs);
        Iterator iter = hitsNode.iterator();
        while (iter.hasNext()) {
            HashMap<String, String> doc = new HashMap<String, String>();
            JsonNode hitNode = (JsonNode)iter.next();
            doc.put("_index", hitNode.get("_index").textValue());
            doc.put("_id", hitNode.get("_id").textValue());
            JsonNode source = hitNode.get("_source");
            Iterator iterator = source.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String fieldName = (String)entry.getKey();
                if (entry.getValue() instanceof TextNode) {
                    doc.put(fieldName, ((JsonNode)entry.getValue()).textValue());
                    continue;
                }
                doc.put(fieldName, (String)entry.getValue());
            }
            docs.add(doc);
        }
        return scrollResult;
    }

    public List<IndexDocsCount> getIndexDocsCount(String index) {
        String endpoint = String.format("/_cat/indices/%s?h=index,docsCount&format=json", index);
        Request request = new Request("GET", endpoint);
        try {
            Response response = this.restClient.performRequest(request);
            if (response == null) {
                throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.GET_INDEX_DOCS_COUNT_FAILED, "GET " + endpoint + " response null");
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                String entity = EntityUtils.toString(response.getEntity());
                List indexDocsCounts = JsonUtils.toList((String)entity, IndexDocsCount.class);
                return indexDocsCounts;
            }
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.GET_INDEX_DOCS_COUNT_FAILED, String.format("GET %s response status code=%d", endpoint, response.getStatusLine().getStatusCode()));
        }
        catch (IOException ex) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.GET_INDEX_DOCS_COUNT_FAILED, ex);
        }
    }

    public List<String> listIndex() {
        String endpoint = "/_cat/indices?format=json";
        Request request = new Request("GET", endpoint);
        try {
            Response response = this.restClient.performRequest(request);
            if (response == null) {
                throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.LIST_INDEX_FAILED, "GET " + endpoint + " response null");
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                String entity = EntityUtils.toString(response.getEntity());
                return JsonUtils.toList((String)entity, Map.class).stream().map(map -> map.get("index").toString()).collect(Collectors.toList());
            }
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.LIST_INDEX_FAILED, String.format("GET %s response status code=%d", endpoint, response.getStatusLine().getStatusCode()));
        }
        catch (IOException ex) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.LIST_INDEX_FAILED, ex);
        }
    }

    public void createIndex(String indexName) {
        String endpoint = String.format("/%s", indexName);
        Request request = new Request("PUT", endpoint);
        try {
            Response response = this.restClient.performRequest(request);
            if (response == null) {
                throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.CREATE_INDEX_FAILED, "PUT " + endpoint + " response null");
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.CREATE_INDEX_FAILED, String.format("PUT %s response status code=%d", endpoint, response.getStatusLine().getStatusCode()));
            }
        }
        catch (IOException ex) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.CREATE_INDEX_FAILED, ex);
        }
    }

    public void dropIndex(String tableName) {
        String endpoint = String.format("/%s", tableName);
        Request request = new Request("DELETE", endpoint);
        try {
            Response response = this.restClient.performRequest(request);
            if (response == null) {
                throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.DROP_INDEX_FAILED, "DELETE " + endpoint + " response null");
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                return;
            }
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.DROP_INDEX_FAILED, String.format("DELETE %s response status code=%d", endpoint, response.getStatusLine().getStatusCode()));
        }
        catch (IOException ex) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.DROP_INDEX_FAILED, ex);
        }
    }

    public Map<String, String> getFieldTypeMapping(String index, List<String> source) {
        String endpoint = String.format("/%s/_mappings", index);
        Request request = new Request("GET", endpoint);
        Map<String, String> mapping = new HashMap<String, String>();
        try {
            Response response = this.restClient.performRequest(request);
            if (response == null) {
                throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.GET_INDEX_DOCS_COUNT_FAILED, "GET " + endpoint + " response null");
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.GET_INDEX_DOCS_COUNT_FAILED, String.format("GET %s response status code=%d", endpoint, response.getStatusLine().getStatusCode()));
            }
            String entity = EntityUtils.toString(response.getEntity());
            log.info(String.format("GET %s respnse=%s", endpoint, entity));
            ObjectNode responseJson = JsonUtils.parseObject((String)entity);
            Iterator it = responseJson.elements();
            while (it.hasNext()) {
                JsonNode indexProperty = (JsonNode)it.next();
                JsonNode mappingsProperty = indexProperty.get("mappings");
                if (mappingsProperty.has("mappingsProperty")) {
                    JsonNode properties = mappingsProperty.get("properties");
                    mapping = EsRestClient.getFieldTypeMappingFromProperties(properties, source);
                    continue;
                }
                for (JsonNode typeNode : mappingsProperty) {
                    JsonNode properties = typeNode.has("properties") ? typeNode.get("properties") : typeNode;
                    mapping.putAll(EsRestClient.getFieldTypeMappingFromProperties(properties, source));
                }
            }
        }
        catch (IOException ex) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)ElasticsearchConnectorErrorCode.GET_INDEX_DOCS_COUNT_FAILED, ex);
        }
        return mapping;
    }

    private static Map<String, String> getFieldTypeMappingFromProperties(JsonNode properties, List<String> source) {
        HashMap<String, String> allElasticSearchFieldTypeInfoMap = new HashMap<String, String>();
        properties.fields().forEachRemaining(entry -> {
            String fieldName = (String)entry.getKey();
            JsonNode fieldProperty = (JsonNode)entry.getValue();
            if (fieldProperty.has("type")) {
                allElasticSearchFieldTypeInfoMap.put(fieldName, fieldProperty.get("type").asText());
            }
        });
        if (CollectionUtils.isEmpty(source)) {
            return allElasticSearchFieldTypeInfoMap;
        }
        return source.stream().collect(Collectors.toMap(Function.identity(), fieldName -> {
            String fieldType = (String)allElasticSearchFieldTypeInfoMap.get(fieldName);
            if (fieldType == null) {
                log.warn("fail to get elasticsearch field {} mapping type,so give a default type text", fieldName);
                return "text";
            }
            return fieldType;
        }));
    }
}

