/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.source;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.exception.ElasticsearchConnectorException;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.source.ElasticsearchRecord;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.serialize.source.SeaTunnelRowDeserializer;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.node.TextNode;

public class DefaultSeaTunnelRowDeserializer
implements SeaTunnelRowDeserializer {
    private final SeaTunnelRowType rowTypeInfo;
    private final ObjectMapper mapper = new ObjectMapper();
    private final Map<Integer, DateTimeFormatter> dateTimeFormatterMap = new HashMap<Integer, DateTimeFormatter>(){
        {
            this.put("yyyy-MM-dd HH".length(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH"));
            this.put("yyyy-MM-dd HH:mm".length(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            this.put("yyyyMMdd HH:mm:ss".length(), DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss"));
            this.put("yyyy-MM-dd HH:mm:ss".length(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            this.put("yyyy-MM-dd HH:mm:ss.S".length(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S"));
            this.put("yyyy-MM-dd HH:mm:ss.SS".length(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SS"));
            this.put("yyyy-MM-dd HH:mm:ss.SSS".length(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
            this.put("yyyy-MM-dd HH:mm:ss.SSSS".length(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSS"));
            this.put("yyyy-MM-dd HH:mm:ss.SSSSSS".length(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS"));
        }
    };

    public DefaultSeaTunnelRowDeserializer(SeaTunnelRowType rowTypeInfo) {
        this.rowTypeInfo = rowTypeInfo;
    }

    @Override
    public SeaTunnelRow deserialize(ElasticsearchRecord rowRecord) {
        return this.convert(rowRecord);
    }

    SeaTunnelRow convert(ElasticsearchRecord rowRecord) {
        Object[] seaTunnelFields = new Object[this.rowTypeInfo.getTotalFields()];
        String fieldName = null;
        Object value = null;
        SeaTunnelDataType seaTunnelDataType = null;
        try {
            for (int i = 0; i < this.rowTypeInfo.getTotalFields(); ++i) {
                fieldName = this.rowTypeInfo.getFieldName(i);
                value = this.recursiveGet(rowRecord.getDoc(), fieldName);
                if (value == null) continue;
                seaTunnelDataType = this.rowTypeInfo.getFieldType(i);
                seaTunnelFields[i] = value instanceof TextNode ? this.convertValue(seaTunnelDataType, ((TextNode)value).textValue()) : this.convertValue(seaTunnelDataType, value.toString());
            }
        }
        catch (Exception ex) {
            throw new ElasticsearchConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("error fieldName=%s,fieldValue=%s,seaTunnelDataType=%s,rowRecord=%s", fieldName, value, seaTunnelDataType, JsonUtils.toJsonString((Object)rowRecord)), ex);
        }
        return new SeaTunnelRow(seaTunnelFields);
    }

    Object convertValue(SeaTunnelDataType<?> fieldType, String fieldValue) throws JsonProcessingException {
        if (BasicType.BOOLEAN_TYPE.equals(fieldType)) {
            return Boolean.parseBoolean(fieldValue);
        }
        if (BasicType.BYTE_TYPE.equals(fieldType)) {
            return Byte.valueOf(fieldValue);
        }
        if (BasicType.SHORT_TYPE.equals(fieldType)) {
            return Short.parseShort(fieldValue);
        }
        if (BasicType.INT_TYPE.equals(fieldType)) {
            return Integer.parseInt(fieldValue);
        }
        if (BasicType.LONG_TYPE.equals(fieldType)) {
            return Long.parseLong(fieldValue);
        }
        if (BasicType.FLOAT_TYPE.equals(fieldType)) {
            return Float.valueOf(Float.parseFloat(fieldValue));
        }
        if (BasicType.DOUBLE_TYPE.equals(fieldType)) {
            return Double.parseDouble(fieldValue);
        }
        if (BasicType.STRING_TYPE.equals(fieldType)) {
            return fieldValue;
        }
        if (LocalTimeType.LOCAL_DATE_TYPE.equals(fieldType)) {
            LocalDateTime localDateTime = this.parseDate(fieldValue);
            return localDateTime.toLocalDate();
        }
        if (LocalTimeType.LOCAL_TIME_TYPE.equals(fieldType)) {
            LocalDateTime localDateTime = this.parseDate(fieldValue);
            return localDateTime.toLocalTime();
        }
        if (LocalTimeType.LOCAL_DATE_TIME_TYPE.equals(fieldType)) {
            return this.parseDate(fieldValue);
        }
        if (fieldType instanceof DecimalType) {
            return new BigDecimal(fieldValue);
        }
        if (fieldType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)fieldType;
            BasicType elementType = arrayType.getElementType();
            List stringList = JsonUtils.toList((String)fieldValue, String.class);
            Object arr = Array.newInstance(elementType.getTypeClass(), stringList.size());
            for (int i = 0; i < stringList.size(); ++i) {
                Object convertValue = this.convertValue((SeaTunnelDataType<?>)elementType, (String)stringList.get(i));
                Array.set(arr, i, convertValue);
            }
            return arr;
        }
        if (fieldType instanceof MapType) {
            MapType mapType = (MapType)fieldType;
            SeaTunnelDataType keyType = mapType.getKeyType();
            SeaTunnelDataType valueType = mapType.getValueType();
            Map stringMap = (Map)this.mapper.readValue(fieldValue, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            HashMap<Object, Object> convertMap = new HashMap<Object, Object>();
            for (Map.Entry entry : stringMap.entrySet()) {
                Object convertKey = this.convertValue(keyType, (String)entry.getKey());
                Object convertValue = this.convertValue(valueType, (String)entry.getValue());
                convertMap.put(convertKey, convertValue);
            }
            return convertMap;
        }
        if (fieldType instanceof PrimitiveByteArrayType) {
            return Base64.getDecoder().decode(fieldValue);
        }
        if (BasicType.VOID_TYPE.equals(fieldType) || fieldType == null) {
            return null;
        }
        throw new ElasticsearchConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Unexpected value: " + fieldType);
    }

    private LocalDateTime parseDate(String fieldValue) {
        try {
            long ts = Long.parseLong(fieldValue);
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(ts), ZoneId.systemDefault());
        }
        catch (NumberFormatException ts) {
            DateTimeFormatter dateTimeFormatter;
            String formatDate = fieldValue.replace("T", " ");
            if (fieldValue.length() == "yyyyMMdd".length() || fieldValue.length() == "yyyy-MM-dd".length()) {
                formatDate = fieldValue + " 00:00:00";
            }
            if ((dateTimeFormatter = this.dateTimeFormatterMap.get(formatDate.length())) == null) {
                throw new ElasticsearchConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "unsupported date format");
            }
            return LocalDateTime.parse(formatDate, dateTimeFormatter);
        }
    }

    Object recursiveGet(Map<String, Object> collect, String keyWithRecursive) {
        Object value = null;
        boolean isFirst = true;
        for (String key : keyWithRecursive.split("\\.")) {
            if (isFirst) {
                value = collect.get(key);
                isFirst = false;
                continue;
            }
            if (!(value instanceof ObjectNode)) continue;
            value = ((ObjectNode)value).get(key);
        }
        return value;
    }
}

