/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.elasticsearch.source;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.catalog.ElasticSearchDataTypeConvertor;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.client.EsRestClient;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceReader;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.elasticsearch.source.ElasticsearchSourceState;

public class ElasticsearchSource
implements SeaTunnelSource<SeaTunnelRow, ElasticsearchSourceSplit, ElasticsearchSourceState>,
SupportParallelism,
SupportColumnProjection {
    private final ReadonlyConfig config;
    private CatalogTable catalogTable;
    private List<String> source;

    public ElasticsearchSource(ReadonlyConfig config) {
        this.config = config;
        if (config.getOptional(TableSchemaOptions.SCHEMA).isPresent()) {
            this.catalogTable = CatalogTableUtil.buildWithConfig((ReadonlyConfig)config);
            this.source = Arrays.asList(this.catalogTable.getSeaTunnelRowType().getFieldNames());
        } else {
            this.source = (List)config.get(SourceConfig.SOURCE);
            EsRestClient esRestClient = EsRestClient.createInstance(config);
            Map<String, String> esFieldType = esRestClient.getFieldTypeMapping((String)config.get(SourceConfig.INDEX), this.source);
            esRestClient.close();
            SeaTunnelDataType[] fieldTypes = new SeaTunnelDataType[this.source.size()];
            ElasticSearchDataTypeConvertor elasticSearchDataTypeConvertor = new ElasticSearchDataTypeConvertor();
            for (int i = 0; i < this.source.size(); ++i) {
                SeaTunnelDataType<?> seaTunnelDataType;
                String esType = esFieldType.get(this.source.get(i));
                fieldTypes[i] = seaTunnelDataType = elasticSearchDataTypeConvertor.toSeaTunnelType(this.source.get(i), esType);
            }
            TableSchema.Builder builder = TableSchema.builder();
            for (int i = 0; i < this.source.size(); ++i) {
                builder.column((Column)PhysicalColumn.of((String)this.source.get(i), (SeaTunnelDataType)fieldTypes[i], (Integer)0, (boolean)true, null, null));
            }
            this.catalogTable = CatalogTable.of((TableIdentifier)TableIdentifier.of((String)"elasticsearch", null, (String)((String)config.get(SourceConfig.INDEX))), (TableSchema)builder.build(), Collections.emptyMap(), Collections.emptyList(), (String)"");
        }
    }

    public String getPluginName() {
        return "Elasticsearch";
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return Collections.singletonList(this.catalogTable);
    }

    public SourceReader<SeaTunnelRow, ElasticsearchSourceSplit> createReader(SourceReader.Context readerContext) {
        return new ElasticsearchSourceReader(readerContext, this.config, this.catalogTable.getSeaTunnelRowType());
    }

    public SourceSplitEnumerator<ElasticsearchSourceSplit, ElasticsearchSourceState> createEnumerator(SourceSplitEnumerator.Context<ElasticsearchSourceSplit> enumeratorContext) {
        return new ElasticsearchSourceSplitEnumerator(enumeratorContext, this.config, this.source);
    }

    public SourceSplitEnumerator<ElasticsearchSourceSplit, ElasticsearchSourceState> restoreEnumerator(SourceSplitEnumerator.Context<ElasticsearchSourceSplit> enumeratorContext, ElasticsearchSourceState sourceState) {
        return new ElasticsearchSourceSplitEnumerator(enumeratorContext, sourceState, this.config, this.source);
    }
}

